/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.handler;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.jeirei.CraftingHelper;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiRecipe;
import java.util.Map;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import org.blocovermelho.ae2emicrafting.client.handler.generic.Ae2BaseRecipeHandler;
import org.blocovermelho.ae2emicrafting.client.helper.RecipeUtils;
import org.blocovermelho.ae2emicrafting.client.helper.rendering.Result;
import org.blocovermelho.ae2emicrafting.client.recipes.generator.RecipeGenerator;

public class Ae2CraftingHandler<T extends CraftingTermMenu>
extends Ae2BaseRecipeHandler<T> {
    public Ae2CraftingHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected Result transferRecipe(T menu, class_1860<?> recipe, EmiRecipe emiRecipe, boolean doTransfer) {
        boolean craftingRecipe = RecipeUtils.isCraftingRecipe(recipe, emiRecipe);
        if (!craftingRecipe) {
            return Result.createNotApplicable();
        }
        if (!RecipeUtils.fitsIn3x3Grid(recipe)) {
            return Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (recipe == null) {
            recipe = RecipeGenerator.createFakeRecipe(emiRecipe);
        }
        Map<Integer, class_1856> slotToIngredientMap = RecipeUtils.getGuiSlotToIngredientMap(recipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = menu.findMissingIngredients(RecipeUtils.getGuiSlotToIngredientMap(recipe));
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            return Result.createFailed((class_2561)ItemModText.NO_ITEMS.text(), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.anyMissing() || missingSlots.anyCraftable()) {
                return new Result.PartiallyCraftable(missingSlots);
            }
        } else {
            boolean craftMissing = class_465.method_25441();
            CraftingHelper.performTransfer(menu, recipe, (boolean)craftMissing);
        }
        return Result.createSuccessful();
    }
}

