/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.recipes;

import appeng.api.config.CondenserOutput;
import appeng.api.implementations.items.IStorageComponent;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.ButtonToolTips;
import com.google.common.base.Splitter;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.blocovermelho.ae2emicrafting.client.recipes.category.Ae2CategoryHolder;

public class Ae2CondenserRecipe
extends BasicEmiRecipe {
    private final CondenserOutput type;
    private final EmiIngredient viableStorageComponents;
    private final EmiStack output;

    public Ae2CondenserRecipe(CondenserOutput source) {
        super((EmiRecipeCategory)Ae2CategoryHolder.CONDENSER, Ae2CondenserRecipe.getRecipeId(source), 94, 48);
        this.type = source;
        this.output = EmiStack.of((class_1799)Ae2CondenserRecipe.getOutput(source));
        this.outputs.add(this.output);
        this.viableStorageComponents = EmiIngredient.of(Ae2CondenserRecipe.getCandidates(source));
        this.catalysts.add(this.viableStorageComponents);
    }

    public void addWidgets(WidgetHolder widgets) {
        class_2960 background = AppEng.makeId((String)"textures/guis/condenser.png");
        widgets.addTexture(background, 0, 0, 94, 48, 50, 25);
        class_2960 statesLocation = AppEng.makeId((String)"textures/guis/states.png");
        widgets.addTexture(statesLocation, 2, 28, 14, 14, 241, 81);
        widgets.addTexture(statesLocation, 78, 28, 16, 16, 240, 240);
        widgets.addAnimatedTexture(background, 70, 0, 6, 18, 178, 25, 2000, false, true, false);
        if (this.type == CondenserOutput.MATTER_BALLS) {
            widgets.addTexture(statesLocation, 78, 28, 14, 14, 16, 112);
        } else if (this.type == CondenserOutput.SINGULARITY) {
            widgets.addTexture(statesLocation, 78, 28, 14, 14, 32, 112);
        }
        widgets.addTooltipText(this.getTooltip(this.type), 78, 28, 16, 16);
        widgets.addSlot((EmiIngredient)this.output, 54, 26).drawBack(false);
        widgets.addSlot(this.viableStorageComponents, 50, 0).drawBack(false);
    }

    private static List<EmiStack> getCandidates(CondenserOutput kind) {
        return Stream.of(AEItems.CELL_COMPONENT_1K, AEItems.CELL_COMPONENT_4K, AEItems.CELL_COMPONENT_16K, AEItems.CELL_COMPONENT_64K, AEItems.CELL_COMPONENT_256K).map(ItemDefinition::stack).filter(x -> Ae2CondenserRecipe.isViableFor(x, kind)).map(EmiStack::of).toList();
    }

    private static boolean isViableFor(class_1799 stack, CondenserOutput kind) {
        IStorageComponent component = (IStorageComponent)stack.method_7909();
        int storageBytes = component.getBytes(stack) * 8;
        return storageBytes >= kind.requiredPower;
    }

    private static class_2960 getRecipeId(CondenserOutput type) {
        return AppEng.makeId((String)type.name().toLowerCase(Locale.ROOT));
    }

    private static class_1799 getOutput(CondenserOutput recipe) {
        return switch (recipe) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> class_1799.field_8037;
        };
    }

    private List<class_2561> getTooltip(CondenserOutput type) {
        String key;
        switch (type) {
            case MATTER_BALLS: {
                key = ButtonToolTips.MatterBalls.getTranslationKey();
                break;
            }
            case SINGULARITY: {
                key = ButtonToolTips.Singularity.getTranslationKey();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return Splitter.on((String)"\n").splitToList((CharSequence)class_2561.method_43469((String)key, (Object[])new Object[]{type.requiredPower}).getString()).stream().map(class_2561::method_43470).toList();
    }
}

