/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.recipes;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.ItemModText;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import org.blocovermelho.ae2emicrafting.client.recipes.category.Ae2CategoryHolder;
import org.blocovermelho.ae2emicrafting.client.widget.slot.EntropySlot;
import org.jetbrains.annotations.NotNull;

public class Ae2EntropyManipulatorRecipe
extends BasicEmiRecipe {
    private static final int BODY_TEXT_COLOR = 0x7E7E7E;
    private final EmiStack inputBlockIngredient;
    private final boolean inputFluidFlowing;
    private final EmiStack outputBlockIngredient;
    private final boolean outputFluidFlowing;
    private final List<EmiStack> additionalDrops;
    private final boolean inputConsumed;
    private final EntropyRecipe recipe;

    public Ae2EntropyManipulatorRecipe(EntropyRecipe source) {
        super((EmiRecipeCategory)Ae2CategoryHolder.ENTROPY, source.method_8114(), 130, 50);
        class_2248 iB = source.getInputBlock();
        class_3611 iF = source.getInputFluid();
        this.inputBlockIngredient = Ae2EntropyManipulatorRecipe.createIngredient(iB, iF);
        this.inputFluidFlowing = iF != null && Ae2EntropyManipulatorRecipe.isFlowing(iF);
        class_2248 oB = source.getOutputBlock();
        class_3611 oF = source.getOutputFluid();
        this.outputBlockIngredient = Ae2EntropyManipulatorRecipe.createIngredient(oB, oF);
        this.outputFluidFlowing = oF != null && Ae2EntropyManipulatorRecipe.isFlowing(oF);
        boolean bl = this.inputConsumed = oB != null && oB.method_9564().method_26215() && (oF == null || oF == class_3612.field_15906);
        if (!this.inputConsumed) {
            this.inputBlockIngredient.setRemainder(this.inputBlockIngredient);
        }
        this.additionalDrops = source.getDrops().stream().map(EmiStack::of).toList();
        this.inputs.add(this.inputBlockIngredient);
        this.outputs.add(this.outputBlockIngredient);
        this.outputs.addAll(this.additionalDrops);
        this.recipe = source;
    }

    public void addWidgets(WidgetHolder widgets) {
        int centerX = this.width / 2;
        class_5250 labelText = switch (this.recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.ENTROPY_MANIPULATOR_HEAT.text(new Object[]{1600});
            case EntropyMode.COOL -> ItemModText.ENTROPY_MANIPULATOR_COOL.text(new Object[]{1600});
        };
        class_5250 interaction = switch (this.recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.RIGHT_CLICK.text();
            case EntropyMode.COOL -> ItemModText.SHIFT_RIGHT_CLICK.text();
        };
        TextWidget modeLabel = widgets.addText((class_2561)labelText, centerX + 4, 2, 0x7E7E7E, false).horizontalAlign(TextWidget.Alignment.CENTER);
        int modeLabelX = modeLabel.getBounds().x();
        switch (this.recipe.getMode()) {
            case HEAT: {
                widgets.addTexture(AppEng.makeId((String)"textures/guis/jei.png"), modeLabelX - 9, 3, 6, 6, 0, 68);
                break;
            }
            case COOL: {
                widgets.addTexture(AppEng.makeId((String)"textures/guis/jei.png"), modeLabelX - 9, 3, 6, 6, 6, 68);
            }
        }
        widgets.addTexture(EmiTexture.EMPTY_ARROW, centerX - 12, 14);
        widgets.addText((class_2561)interaction, centerX, 38, 0x7E7E7E, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.add((Widget)new EntropySlot((EmiIngredient)this.inputBlockIngredient, false, this.inputFluidFlowing, this.width / 2 - 35, 14));
        int x = centerX + 20;
        if (this.inputConsumed) {
            widgets.add((Widget)new EntropySlot((EmiIngredient)this.inputBlockIngredient, true, this.outputFluidFlowing, x - 1, 14));
            x += 18;
        } else if (!this.outputBlockIngredient.isEmpty()) {
            widgets.add((Widget)new EntropySlot((EmiIngredient)this.outputBlockIngredient, false, this.outputFluidFlowing, x - 1, 14).recipeContext((EmiRecipe)this));
            x += 18;
        }
        for (EmiStack drop : this.additionalDrops) {
            widgets.addSlot((EmiIngredient)drop, x - 1, 14).recipeContext((EmiRecipe)this);
            x += 18;
        }
    }

    private static boolean isFlowing(@NotNull class_3611 fluid) {
        return fluid != class_3612.field_15906 && !fluid.method_15793(fluid.method_15785());
    }

    private static EmiStack createIngredient(class_2248 block, class_3611 fluid) {
        if (fluid != null) {
            if (!fluid.method_15793(fluid.method_15785())) {
                if (fluid instanceof class_3609) {
                    class_3609 flowingFluid = (class_3609)fluid;
                    return EmiStack.of((class_3611)flowingFluid.method_15751());
                }
                AELog.warn((String)"Don't know how to get the source fluid for %s", (Object[])new Object[]{fluid});
                return EmiStack.of((class_3611)fluid);
            }
            return EmiStack.of((class_3611)fluid);
        }
        if (block != null) {
            return EmiStack.of((class_1799)block.method_8389().method_7854());
        }
        return EmiStack.EMPTY;
    }
}

