/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import io.wispforest.owo.util.RecipeRemainderStorage;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.block.ForgeControllerBlockEntity;
import wraith.alloyforgery.recipe.AlloyForgeRecipeSerializer;

public class AlloyForgeRecipe
implements class_1860<class_1263> {
    private static final Map<class_1792, class_1799> GLOBAL_REMAINDERS = new HashMap<class_1792, class_1799>();
    private static final List<Integer> INPUT_SLOT_INDICES = IntStream.rangeClosed(0, 9).boxed().toList();
    public static final Map<AlloyForgeRecipe, PendingRecipeData> PENDING_RECIPES = new HashMap<AlloyForgeRecipe, PendingRecipeData>();
    private final class_2960 id;
    private Optional<class_2960> secondaryID = Optional.empty();
    private final Map<class_1856, Integer> inputs;
    private class_1799 output;
    private final int minForgeTier;
    private final int fuelPerTick;
    private ImmutableMap<OverrideRange, class_1799> tierOverrides;

    public AlloyForgeRecipe(class_2960 id, Map<class_1856, Integer> inputs, class_1799 output, int minForgeTier, int fuelPerTick, ImmutableMap<OverrideRange, class_1799> overrides) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.fuelPerTick = fuelPerTick;
        this.tierOverrides = overrides;
    }

    public AlloyForgeRecipe setSecondaryID(class_2960 id) {
        this.secondaryID = Optional.of(id);
        return this;
    }

    public Optional<class_2960> secondaryID() {
        return this.secondaryID;
    }

    public void finishRecipe(PendingRecipeData pendingData) {
        if (pendingData.defaultTag() != null) {
            Optional itemEntryList = class_7923.field_41178.method_40266((class_6862)pendingData.defaultTag().method_15442());
            itemEntryList.ifPresentOrElse(registryEntries -> {
                this.output = ((class_1792)registryEntries.method_40240(0).comp_349()).method_7854();
                this.output.method_7939(((Integer)pendingData.defaultTag().method_15441()).intValue());
            }, () -> {
                throw new InvalidTagException("Default tag " + ((class_6862)pendingData.defaultTag().method_15442()).comp_327() + " of recipe " + this.id + " must not be empty");
            });
        }
        ImmutableMap.Builder overrides = ImmutableMap.builder();
        pendingData.unfinishedTierOverrides().forEach((range, override) -> {
            if (override.isCountOnly()) {
                class_1799 stack = this.output.method_7972();
                stack.method_7939(override.count());
                overrides.put(range, (Object)stack);
            } else if (override.stack() != null) {
                overrides.put(range, (Object)override.stack());
            }
        });
        this.tierOverrides = overrides.build();
    }

    public static void addRemainders(Map<class_1792, class_1799> remainders) {
        GLOBAL_REMAINDERS.putAll(remainders);
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return this.tryBind(inventory) != null;
    }

    public Int2IntMap tryBind(class_1263 inventory) {
        ConcurrentLinkedQueue<Integer> indices = new ConcurrentLinkedQueue<Integer>(INPUT_SLOT_INDICES);
        Int2IntLinkedOpenHashMap boundSlots = new Int2IntLinkedOpenHashMap();
        for (Map.Entry<class_1856, Integer> ingredient : this.inputs.entrySet()) {
            int remaining = ingredient.getValue();
            for (int index : indices) {
                class_1799 stack = inventory.method_5438(index);
                if (!ingredient.getKey().method_8093(stack)) continue;
                boundSlots.put(index, Math.min(stack.method_7947(), remaining));
                indices.remove(index);
                if ((remaining -= stack.method_7947()) > 0) continue;
                break;
            }
            if (remaining <= 0) continue;
            return null;
        }
        Iterator<Object> iterator = indices.iterator();
        block2: while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            class_1799 stack = inventory.method_5438(index);
            if (stack.method_7960()) continue;
            for (class_1856 ingredient : this.inputs.keySet()) {
                if (!ingredient.method_8093(stack)) continue;
                continue block2;
            }
            return null;
        }
        return boundSlots;
    }

    public class_2371<class_1856> method_8117() {
        ArrayList<class_1856> allIngredients = new ArrayList<class_1856>();
        for (Map.Entry<class_1856, Integer> entry : this.inputs.entrySet()) {
            for (int i = 0; i < entry.getValue(); ++i) {
                allIngredients.add(entry.getKey());
            }
        }
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])allIngredients.toArray(class_1856[]::new)));
    }

    public Map<class_1856, Integer> getIngredientsMap() {
        return this.inputs;
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 drm) {
        class_1799 class_17992;
        if (inventory instanceof ForgeControllerBlockEntity) {
            ForgeControllerBlockEntity controller = (ForgeControllerBlockEntity)inventory;
            class_17992 = this.getOutput(controller.getForgeDefinition().forgeTier());
        } else {
            class_17992 = this.method_8110(drm);
        }
        return class_17992;
    }

    public void consumeIngredients(class_1263 inventory) {
        this.tryBind(inventory).forEach((arg_0, arg_1) -> ((class_1263)inventory).method_5434(arg_0, arg_1));
    }

    @Nullable
    public class_2371<class_1799> gatherRemainders(class_1263 inventory) {
        Map owoRemainders;
        class_2371 remainders = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        Map map = owoRemainders = RecipeRemainderStorage.has((class_2960)this.method_8114()) ? RecipeRemainderStorage.get((class_2960)this.method_8114()) : Map.of();
        if (owoRemainders.isEmpty() && GLOBAL_REMAINDERS.isEmpty()) {
            return null;
        }
        boolean setAnyRemainders = false;
        IntIterator intIterator = this.tryBind(inventory).keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            class_1792 item = inventory.method_5438(i).method_7909();
            if (!owoRemainders.isEmpty()) {
                if (!owoRemainders.containsKey(item)) continue;
                remainders.set(i, (Object)((class_1799)owoRemainders.get(item)).method_7972());
                setAnyRemainders = true;
                continue;
            }
            if (!GLOBAL_REMAINDERS.containsKey(item)) continue;
            remainders.set(i, (Object)GLOBAL_REMAINDERS.get(item).method_7972());
            setAnyRemainders = true;
        }
        return setAnyRemainders ? remainders : null;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @Deprecated
    @ApiStatus.Internal
    public class_1799 method_8110(class_5455 drm) {
        return this.output.method_7972();
    }

    @ApiStatus.Internal
    public class_1799 getBaseOutput() {
        return this.output.method_7972();
    }

    public class_1799 getOutput(int forgeTier) {
        class_1799 stack = ((class_1799)this.tierOverrides.getOrDefault(this.tierOverrides.keySet().stream().filter(overrideRange -> overrideRange.test(forgeTier)).findAny().orElse(null), (Object)this.output)).method_7972();
        if (stack.method_7909() == class_1802.field_8162) {
            int stackCount = stack.method_7947();
            stack = this.output.method_7972();
            stack.method_7939(stackCount);
        }
        return stack;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return AlloyForgeRecipeSerializer.INSTANCE;
    }

    public class_3956<?> method_17716() {
        return Type.INSTANCE;
    }

    public int getMinForgeTier() {
        return this.minForgeTier;
    }

    public int getFuelPerTick() {
        return this.fuelPerTick;
    }

    public ImmutableMap<OverrideRange, class_1799> getTierOverrides() {
        return this.tierOverrides;
    }

    public record PendingRecipeData(@Nullable class_3545<class_6862<class_1792>, Integer> defaultTag, ImmutableMap<OverrideRange, PendingOverride> unfinishedTierOverrides) {
    }

    public static class Type
    implements class_3956<AlloyForgeRecipe> {
        public static final class_2960 ID = AlloyForgery.id("forging");
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public record OverrideRange(int lowerBound, int upperBound) {
        public OverrideRange(int lowerBound) {
            this(lowerBound, -1);
        }

        public boolean test(int value) {
            return value >= this.lowerBound && (this.upperBound == -1 || value <= this.upperBound);
        }

        @Override
        public String toString() {
            String outString = String.valueOf(this.lowerBound);
            List<Character> chars = outString.chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
            if (this.upperBound != this.lowerBound) {
                if (this.upperBound == -1) {
                    chars.add(Character.valueOf('+'));
                } else {
                    List<Character> to = " to ".chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
                    to.forEach(character -> chars.add((Character)character));
                    List<Character> bound = String.valueOf(this.upperBound).chars().mapToObj(value -> Character.valueOf((char)value)).collect(Collectors.toList());
                    bound.forEach(character -> chars.add((Character)character));
                }
            }
            StringBuilder output = new StringBuilder();
            chars.forEach(character -> output.append(character));
            return output.toString();
        }
    }

    public record PendingOverride(@Nullable class_1799 stack, int count) {
        public boolean isCountOnly() {
            return this.stack == null;
        }

        public static PendingOverride onlyCount(int count) {
            return new PendingOverride(null, count);
        }

        public static PendingOverride ofStack(class_1799 stack) {
            return new PendingOverride(stack, stack.method_7947());
        }
    }

    public static class InvalidTagException
    extends RuntimeException {
        public InvalidTagException(String message) {
            super(message);
        }
    }
}

