/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.util;

import com.bawnorton.allthetrims.json.TrimMaterialJson;
import com.bawnorton.allthetrims.json.TrimModelOverrideEntryJson;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_7923;

public abstract class TrimMaterialHelper {
    public static final Set<TrimMaterialJson> BUILTIN_TRIM_MATERIALS = new HashSet<TrimMaterialJson>();
    public static final Set<TrimModelOverrideEntryJson> BUILTIN_TRIM_MODEL_OVERRIDES = new HashSet<TrimModelOverrideEntryJson>();

    public static void forEachTrimMaterial(BiConsumer<class_1792, Boolean> consumer) {
        for (class_1792 item : class_7923.field_41178) {
            consumer.accept(item, TrimMaterialHelper.isBuiltinMaterial(item));
        }
    }

    public static void forEachBuiltinTrimMaterial(Consumer<TrimMaterialJson> consumer) {
        for (TrimMaterialJson trimMaterial : BUILTIN_TRIM_MATERIALS) {
            consumer.accept(trimMaterial);
        }
    }

    public static void forEachBuiltinTrimModelOverride(Consumer<TrimModelOverrideEntryJson> consumer) {
        for (TrimModelOverrideEntryJson trimModelOverride : BUILTIN_TRIM_MODEL_OVERRIDES) {
            consumer.accept(trimModelOverride);
        }
    }

    public static boolean isBuiltinMaterial(class_1792 item) {
        return BUILTIN_TRIM_MATERIALS.stream().anyMatch(material -> material.ingredient().equals(class_7923.field_41178.method_10221((Object)item).toString()));
    }
}

