/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class UnifyConfig
extends Config {
    public static final String NAME = "unify";
    private final List<String> modPriorities;
    private final List<String> stoneStrata;
    private final List<String> unbakedTags;
    private final List<String> materials;
    private final Map<class_2960, String> priorityOverrides;
    private final Map<class_2960, Set<class_2960>> customTags;
    private final Map<class_2960, Set<class_2960>> tagOwnerships;
    private final Enum<TagInheritanceMode> itemTagInheritanceMode;
    private final Map<class_2960, Set<Pattern>> itemTagInheritance;
    private final Enum<TagInheritanceMode> blockTagInheritanceMode;
    private final Map<class_2960, Set<Pattern>> blockTagInheritance;
    private final Set<UnifyTag<class_1792>> ignoredTags;
    private final Set<Pattern> ignoredItems;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Set<Pattern> ignoredRecipes;
    private final boolean hideJeiRei;
    private final Map<class_2960, Boolean> ignoredRecipeTypesCache;
    @Nullable
    private Set<UnifyTag<class_1792>> bakedTagsCache;

    public UnifyConfig(List<String> modPriorities, List<String> stoneStrata, List<String> unbakedTags, List<String> materials, Map<class_2960, String> priorityOverrides, Map<class_2960, Set<class_2960>> customTags, Map<class_2960, Set<class_2960>> tagOwnerships, Enum<TagInheritanceMode> itemTagInheritanceMode, Map<class_2960, Set<Pattern>> itemTagInheritance, Enum<TagInheritanceMode> blockTagInheritanceMode, Map<class_2960, Set<Pattern>> blockTagInheritance, Set<UnifyTag<class_1792>> ignoredTags, Set<Pattern> ignoredItems, Set<Pattern> ignoredRecipeTypes, Set<Pattern> ignoredRecipes, boolean hideJeiRei) {
        this.modPriorities = modPriorities;
        this.stoneStrata = stoneStrata;
        this.unbakedTags = unbakedTags;
        this.materials = materials;
        this.priorityOverrides = priorityOverrides;
        this.customTags = customTags;
        this.tagOwnerships = tagOwnerships;
        this.itemTagInheritanceMode = itemTagInheritanceMode;
        this.itemTagInheritance = itemTagInheritance;
        this.blockTagInheritanceMode = blockTagInheritanceMode;
        this.blockTagInheritance = blockTagInheritance;
        this.ignoredTags = ignoredTags;
        this.ignoredItems = ignoredItems;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.ignoredRecipes = ignoredRecipes;
        this.hideJeiRei = hideJeiRei;
        this.ignoredRecipeTypesCache = new HashMap<class_2960, Boolean>();
    }

    public List<String> getModPriorities() {
        return Collections.unmodifiableList(this.modPriorities);
    }

    public List<String> getStoneStrata() {
        return Collections.unmodifiableList(this.stoneStrata);
    }

    public Set<UnifyTag<class_1792>> bakeTags() {
        return this.bakeTags($ -> true);
    }

    public Set<UnifyTag<class_1792>> bakeAndValidateTags(Map<class_2960, Collection<class_6880<class_1792>>> tags) {
        return this.bakeTags(tags::containsKey);
    }

    private Set<UnifyTag<class_1792>> bakeTags(Predicate<class_2960> tagValidator) {
        if (this.bakedTagsCache != null) {
            return this.bakedTagsCache;
        }
        HashSet<UnifyTag<class_1792>> result = new HashSet<UnifyTag<class_1792>>();
        HashSet<UnifyTag<class_1792>> wrongTags = new HashSet<UnifyTag<class_1792>>();
        for (String tag : this.unbakedTags) {
            for (String material : this.materials) {
                String replace = tag.replace("{material}", material);
                class_2960 asRL = class_2960.method_12829((String)replace);
                if (asRL == null) {
                    AlmostUnified.LOG.warn("Could not bake tag <{}> with material <{}>", (Object)tag, (Object)material);
                    continue;
                }
                UnifyTag<class_1792> t = UnifyTag.item(asRL);
                if (this.ignoredTags.contains(t)) continue;
                if (!tagValidator.test(asRL)) {
                    wrongTags.add(t);
                    continue;
                }
                result.add(t);
            }
        }
        if (!wrongTags.isEmpty()) {
            AlmostUnified.LOG.warn("The following tags are invalid and will be ignored: {}", wrongTags.stream().map(UnifyTag::location).collect(Collectors.toList()));
        }
        this.bakedTagsCache = result;
        return result;
    }

    public List<String> getMaterials() {
        return Collections.unmodifiableList(this.materials);
    }

    public Map<class_2960, String> getPriorityOverrides() {
        return Collections.unmodifiableMap(this.priorityOverrides);
    }

    public Map<class_2960, Set<class_2960>> getCustomTags() {
        return Collections.unmodifiableMap(this.customTags);
    }

    public Map<class_2960, Set<class_2960>> getTagOwnerships() {
        return Collections.unmodifiableMap(this.tagOwnerships);
    }

    public boolean shouldInheritItemTag(UnifyTag<class_1792> itemTag, Set<UnifyTag<class_1792>> dominantTags) {
        Set<Pattern> patterns = this.itemTagInheritance.get(itemTag.location());
        boolean result = UnifyConfig.checkPatterns(dominantTags, patterns);
        return this.itemTagInheritanceMode == TagInheritanceMode.ALLOW ? result : !result;
    }

    public boolean shouldInheritBlockTag(UnifyTag<class_2248> itemTag, Set<UnifyTag<class_1792>> dominantTags) {
        Set<Pattern> patterns = this.blockTagInheritance.get(itemTag.location());
        boolean result = UnifyConfig.checkPatterns(dominantTags, patterns);
        return this.blockTagInheritanceMode == TagInheritanceMode.ALLOW ? result : !result;
    }

    private static <T> boolean checkPatterns(Set<UnifyTag<T>> dominantTags, @Nullable Set<Pattern> patterns) {
        if (patterns == null) {
            return false;
        }
        for (Pattern pattern : patterns) {
            for (UnifyTag<T> dominantTag : dominantTags) {
                if (!pattern.matcher(dominantTag.location().toString()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean includeItem(class_2960 item) {
        for (Pattern pattern : this.ignoredItems) {
            if (!pattern.matcher(item.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipe(class_2960 recipe) {
        for (Pattern pattern : this.ignoredRecipes) {
            if (!pattern.matcher(recipe.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean includeRecipeType(class_2960 type) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(type, t -> {
            for (Pattern pattern : this.ignoredRecipeTypes) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean reiOrJeiDisabled() {
        return !this.hideJeiRei;
    }

    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    public static enum TagInheritanceMode {
        ALLOW,
        DENY;

    }

    public static class Serializer
    extends Config.Serializer<UnifyConfig> {
        public static final String MOD_PRIORITIES = "modPriorities";
        public static final String STONE_STRATA = "stoneStrata";
        public static final String TAGS = "tags";
        public static final String MATERIALS = "materials";
        public static final String PRIORITY_OVERRIDES = "priorityOverrides";
        public static final String CUSTOM_TAGS = "customTags";
        public static final String TAG_OWNERSHIPS = "tagOwnerships";
        public static final String ITEM_TAG_INHERITANCE_MODE = "itemTagInheritanceMode";
        public static final String ITEM_TAG_INHERITANCE = "itemTagInheritance";
        public static final String BLOCK_TAG_INHERITANCE_MODE = "blockTagInheritanceMode";
        public static final String BLOCK_TAG_INHERITANCE = "blockTagInheritance";
        public static final String IGNORED_TAGS = "ignoredTags";
        public static final String IGNORED_ITEMS = "ignoredItems";
        public static final String IGNORED_RECIPE_TYPES = "ignoredRecipeTypes";
        public static final String IGNORED_RECIPES = "ignoredRecipes";
        public static final String HIDE_JEI_REI = "itemsHidingJeiRei";

        @Override
        public UnifyConfig deserialize(JsonObject json) {
            AlmostUnifiedPlatform.Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            List<String> modPriorities = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MOD_PRIORITIES)), Defaults.getModPriorities(platform));
            List<String> stoneStrata = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(STONE_STRATA)), Defaults.STONE_STRATA);
            List<String> tags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(TAGS)), Defaults.getTags(platform));
            List<String> materials = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MATERIALS)), Defaults.MATERIALS);
            Map priorityOverrides = this.safeGet(() -> JsonUtils.deserializeMap(json, PRIORITY_OVERRIDES, e -> new class_2960((String)e.getKey()), e -> ((JsonElement)e.getValue()).getAsString()), new HashMap());
            Map customTags = this.safeGet(() -> JsonUtils.deserializeMapSet(json, CUSTOM_TAGS, e -> new class_2960((String)e.getKey()), class_2960::new), new HashMap());
            Map tagOwnerships = this.safeGet(() -> JsonUtils.deserializeMapSet(json, TAG_OWNERSHIPS, e -> new class_2960((String)e.getKey()), class_2960::new), new HashMap());
            TagInheritanceMode itemTagInheritanceMode = this.deserializeTagInheritanceMode(json, ITEM_TAG_INHERITANCE_MODE);
            Map<class_2960, Set<Pattern>> itemTagInheritance = this.deserializePatternsForLocations(json, ITEM_TAG_INHERITANCE);
            TagInheritanceMode blockTagInheritanceMode = this.deserializeTagInheritanceMode(json, BLOCK_TAG_INHERITANCE_MODE);
            Map<class_2960, Set<Pattern>> blockTagInheritance = this.deserializePatternsForLocations(json, BLOCK_TAG_INHERITANCE);
            Set ignoredTags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(IGNORED_TAGS)).stream().map(s -> UnifyTag.item(new class_2960(s))).collect(Collectors.toSet()), new HashSet());
            Set<Pattern> ignoredItems = this.deserializePatterns(json, IGNORED_ITEMS, List.of());
            Set<Pattern> ignoredRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.getIgnoredRecipeTypes(platform));
            Set<Pattern> ignoredRecipes = this.deserializePatterns(json, IGNORED_RECIPES, List.of());
            boolean hideJeiRei = this.safeGet(() -> json.getAsJsonPrimitive(HIDE_JEI_REI).getAsBoolean(), true);
            return new UnifyConfig(modPriorities, stoneStrata, tags, materials, priorityOverrides, customTags, tagOwnerships, itemTagInheritanceMode, itemTagInheritance, blockTagInheritanceMode, blockTagInheritance, ignoredTags, ignoredItems, ignoredRecipeTypes, ignoredRecipes, hideJeiRei);
        }

        private TagInheritanceMode deserializeTagInheritanceMode(JsonObject json, String key) {
            return this.safeGet(() -> TagInheritanceMode.valueOf(json.getAsJsonPrimitive(key).getAsString().toUpperCase()), TagInheritanceMode.ALLOW);
        }

        private Map<class_2960, Set<Pattern>> unsafeDeserializePatternsForLocations(JsonObject rawConfigJson, String baseKey) {
            return JsonUtils.deserializeMapSet(rawConfigJson, baseKey, e -> new class_2960((String)e.getKey()), Pattern::compile);
        }

        private Map<class_2960, Set<Pattern>> deserializePatternsForLocations(JsonObject rawConfigJson, String baseKey) {
            return this.safeGet(() -> this.unsafeDeserializePatternsForLocations(rawConfigJson, baseKey), new HashMap());
        }

        @Override
        public JsonObject serialize(UnifyConfig config) {
            JsonObject json = new JsonObject();
            json.add(MOD_PRIORITIES, (JsonElement)JsonUtils.toArray(config.modPriorities));
            json.add(STONE_STRATA, (JsonElement)JsonUtils.toArray(config.stoneStrata));
            json.add(TAGS, (JsonElement)JsonUtils.toArray(config.unbakedTags));
            json.add(MATERIALS, (JsonElement)JsonUtils.toArray(config.materials));
            JsonObject priorityOverrides = new JsonObject();
            config.priorityOverrides.forEach((tag, mod) -> priorityOverrides.addProperty(tag.toString(), mod));
            json.add(PRIORITY_OVERRIDES, (JsonElement)priorityOverrides);
            JsonObject customTags = new JsonObject();
            config.customTags.forEach((parent, child) -> customTags.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(class_2960::toString).toList())));
            json.add(CUSTOM_TAGS, (JsonElement)customTags);
            JsonObject tagOwnerships = new JsonObject();
            config.tagOwnerships.forEach((parent, child) -> tagOwnerships.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(class_2960::toString).toList())));
            json.add(TAG_OWNERSHIPS, (JsonElement)tagOwnerships);
            JsonObject itemTagInheritance = new JsonObject();
            config.itemTagInheritance.forEach((tag, patterns) -> itemTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(ITEM_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.itemTagInheritanceMode.toString()));
            json.add(ITEM_TAG_INHERITANCE, (JsonElement)itemTagInheritance);
            JsonObject blockTagInheritance = new JsonObject();
            config.blockTagInheritance.forEach((tag, patterns) -> blockTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(BLOCK_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.blockTagInheritanceMode.toString()));
            json.add(BLOCK_TAG_INHERITANCE, (JsonElement)blockTagInheritance);
            json.add(IGNORED_TAGS, (JsonElement)JsonUtils.toArray(config.ignoredTags.stream().map(UnifyTag::location).map(class_2960::toString).toList()));
            this.serializePatterns(json, IGNORED_ITEMS, config.ignoredItems);
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoredRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES, config.ignoredRecipes);
            json.addProperty(HIDE_JEI_REI, Boolean.valueOf(config.hideJeiRei));
            return json;
        }
    }
}

