/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AEKeyRendering {
    private static volatile Map<AEKeyType, AEKeyRenderHandler<?>> renderers = new IdentityHashMap();

    public static synchronized <T extends AEKey> void register(AEKeyType channel, Class<T> keyClass, AEKeyRenderHandler<T> handler) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(handler, "handler");
        Objects.requireNonNull(keyClass, "keyClass");
        Preconditions.checkArgument((channel.getKeyClass() == keyClass ? 1 : 0) != 0, (String)"%s != %s", channel.getKeyClass(), keyClass);
        IdentityHashMap renderersCopy = new IdentityHashMap(renderers);
        if (renderersCopy.put(channel, handler) != null) {
            throw new IllegalArgumentException("Duplicate registration of render handler for channel " + channel);
        }
        renderers = renderersCopy;
    }

    @Nullable
    public static AEKeyRenderHandler<?> get(AEKeyType channel) {
        return renderers.get(channel);
    }

    public static AEKeyRenderHandler<?> getOrThrow(AEKeyType channel) {
        AEKeyRenderHandler<?> renderHandler = AEKeyRendering.get(channel);
        if (renderHandler == null) {
            throw new IllegalArgumentException("Missing render handler for channel " + channel);
        }
        return renderHandler;
    }

    private static AEKeyRenderHandler getUnchecked(AEKey stack) {
        return AEKeyRendering.getOrThrow(stack.getType());
    }

    public static void drawInGui(class_310 minecraft, class_332 guiGraphics, int x, int y, AEKey what) {
        AEKeyRendering.getUnchecked(what).drawInGui(minecraft, guiGraphics, x, y, what);
    }

    public static void drawOnBlockFace(class_4587 poseStack, class_4597 buffers, AEKey what, float scale, int combinedLightIn, class_1937 level) {
        AEKeyRendering.getUnchecked(what).drawOnBlockFace(poseStack, buffers, what, scale, combinedLightIn, level);
    }

    public static class_2561 getDisplayName(AEKey stack) {
        return AEKeyRendering.getUnchecked(stack).getDisplayName(stack);
    }

    public static List<class_2561> getTooltip(AEKey stack) {
        return new ArrayList<class_2561>(AEKeyRendering.getUnchecked(stack).getTooltip(stack));
    }
}

