/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AEAxisAlignedBB;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.ChargerBlockEntity;
import appeng.client.render.effects.LightningArcParticleData;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import appeng.util.InteractionUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChargerBlock
extends AEBaseEntityBlock<ChargerBlockEntity> {
    public ChargerBlock() {
        super(ChargerBlock.metalProps().method_22488());
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.full();
    }

    public int method_9505(class_2680 state, class_1922 level, class_2338 pos) {
        return 2;
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        ChargerBlockEntity tc;
        if (InteractionUtil.isInAlternateUseMode(player)) {
            return class_1269.field_5811;
        }
        if (!level.method_8608() && (tc = (ChargerBlockEntity)this.getBlockEntity((class_1922)level, pos)) != null) {
            tc.activate(player);
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        ChargerBlockEntity blockEntity = (ChargerBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (blockEntity != null && blockEntity.isWorking()) {
            if ((double)r.method_43057() < 0.5) {
                return;
            }
            BlockOrientation rotation = BlockOrientation.get(blockEntity);
            for (int bolts = 0; bolts < 3; ++bolts) {
                float xOff = class_3532.method_32750((class_5819)r, (float)-0.15f, (float)0.15f);
                float zOff = class_3532.method_32750((class_5819)r, (float)-0.15f, (float)0.15f);
                Vector3f center = new Vector3f((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
                Vector3f origin = new Vector3f(xOff, -0.3f, zOff);
                origin.rotate((Quaternionfc)rotation.getQuaternion());
                origin.add((Vector3fc)center);
                Vector3f target = new Vector3f(xOff, 0.3f, zOff);
                target.rotate((Quaternionfc)rotation.getQuaternion());
                target.add((Vector3fc)center);
                if (r.method_43056()) {
                    Vector3f tmp = target;
                    target = origin;
                    origin = tmp;
                }
                if (!AppEngClient.instance().shouldAddParticles(r)) continue;
                class_310.method_1551().field_1713.method_3056((class_2394)new LightningArcParticleData(new class_243(target)), (double)origin.x(), (double)origin.y(), (double)origin.z(), 0.0, 0.0, 0.0);
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        BlockOrientation orientation = this.getOrientation(state);
        class_2350 up = orientation.getSide(RelativeSide.TOP);
        class_2350 forward = orientation.getSide(RelativeSide.FRONT);
        double twoPixels = 0.125;
        AEAxisAlignedBB bb = new AEAxisAlignedBB(twoPixels, twoPixels, twoPixels, 1.0 - twoPixels, 1.0 - twoPixels, 1.0 - twoPixels);
        if (up.method_10148() != 0) {
            bb.minX = 0.0;
            bb.maxX = 1.0;
        }
        if (up.method_10164() != 0) {
            bb.minY = 0.0;
            bb.maxY = 1.0;
        }
        if (up.method_10165() != 0) {
            bb.minZ = 0.0;
            bb.maxZ = 1.0;
        }
        switch (forward) {
            case field_11033: {
                bb.maxY = 1.0;
                break;
            }
            case field_11036: {
                bb.minY = 0.0;
                break;
            }
            case field_11043: {
                bb.maxZ = 1.0;
                break;
            }
            case field_11035: {
                bb.minZ = 0.0;
                break;
            }
            case field_11034: {
                bb.minX = 0.0;
                break;
            }
            case field_11039: {
                bb.maxX = 1.0;
                break;
            }
        }
        return class_259.method_1078((class_238)bb.getBoundingBox());
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1078((class_238)new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

