/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class QuartzFixtureBlock
extends AEBaseBlock
implements class_3737 {
    private static final Map<class_2350, class_265> SHAPES = new EnumMap<class_2350, class_265>(class_2350.class);
    public static final class_2753 FACING;
    public static final class_2746 ODD;
    public static final class_2746 WATERLOGGED;

    public QuartzFixtureBlock() {
        super(QuartzFixtureBlock.fixtureProps().method_9631(b -> 15));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ODD, WATERLOGGED});
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350[] adirection;
        class_2680 state = super.method_9605(context);
        class_2338 pos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(pos);
        boolean oddPlacement = (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 != 0;
        state = (class_2680)((class_2680)state.method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(oddPlacement))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        class_1937 levelReader = context.method_8045();
        for (class_2350 direction : adirection = context.method_7718()) {
            class_2680 placedState = (class_2680)state.method_11657((class_2769)FACING, (Comparable)direction.method_10153());
            if (!this.method_9558(placedState, (class_4538)levelReader, pos)) continue;
            return placedState;
        }
        return null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)level, currentPos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return SHAPES.get(facing);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.method_43057() < 0.98) {
            return;
        }
        BlockOrientation orientation = this.getOrientation(state);
        class_2350 top = orientation.getSide(RelativeSide.TOP);
        double xOff = -0.3 * (double)top.method_10148();
        double yOff = -0.3 * (double)top.method_10164();
        double zOff = -0.3 * (double)top.method_10165();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEngClient.instance().shouldAddParticles(r)) continue;
            level.method_8406((class_2394)ParticleTypes.LIGHTNING, xOff + 0.5 + (double)pos.method_10263(), yOff + 0.5 + (double)pos.method_10264(), zOff + 0.5 + (double)pos.method_10260(), 0.0, 0.0, 0.0);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 blockPos = pos.method_10093(facing.method_10153());
        return QuartzFixtureBlock.method_20044((class_4538)level, (class_2338)blockPos, (class_2350)facing);
    }

    public class_3610 method_9545(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    static {
        for (class_2350 facing : class_2350.values()) {
            double xOff = -0.3 * (double)facing.method_10148();
            double yOff = -0.3 * (double)facing.method_10164();
            double zOff = -0.3 * (double)facing.method_10165();
            class_265 shape = class_259.method_1078((class_238)new class_238(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = class_2741.field_12525;
        ODD = class_2746.method_11825((String)"odd");
        WATERLOGGED = class_2741.field_12508;
    }
}

