/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.DeferredBlockEntityUnloader;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.hooks.VisualStateSaving;
import appeng.hooks.ticking.TickHandler;
import appeng.items.tools.MemoryCardItem;
import appeng.util.CustomNameUtil;
import appeng.util.SettingsFrom;
import appeng.util.helpers.ItemComparisonHelper;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import net.minecraft.class_3965;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public class AEBaseBlockEntity
extends class_2586
implements class_1275,
ISegmentedInventory,
RenderAttachmentBlockEntity,
class_3829 {
    private static final Map<class_2591<?>, class_1792> REPRESENTATIVE_ITEMS;
    @Nullable
    private class_2561 customName;
    private boolean setChangedQueued = false;
    private byte queuedForReady = 0;
    private byte readyInvoked = 0;
    @Nullable
    private BlockOrientation pendingOrientationChange;

    protected void onChunkUnloaded() {
    }

    public AEBaseBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    public static void registerBlockEntityItem(class_2591<?> type, class_1792 wat) {
        REPRESENTATIVE_ITEMS.put(type, wat);
    }

    public boolean notLoaded() {
        return !this.field_11863.method_22340(this.field_11867);
    }

    public final class_4208 getGlobalPos() {
        if (this.field_11863 == null) {
            throw new IllegalStateException("Block entity is not in a level");
        }
        return class_4208.method_19443((class_5321)this.field_11863.method_27983(), (class_2338)this.method_11016());
    }

    public class_2586 getBlockEntity() {
        return this;
    }

    protected class_1792 getItemFromBlockEntity() {
        return REPRESENTATIVE_ITEMS.getOrDefault(this.method_11017(), class_1802.field_8162);
    }

    public final void method_11014(class_2487 tag) {
        if (tag.method_10573("#upd", 7) && tag.method_10546() == 1) {
            byte[] updateData = tag.method_10547("#upd");
            if (this.readUpdateData(new class_2540(Unpooled.wrappedBuffer((byte[])updateData))) && this.field_11863 != null) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
            }
            return;
        }
        if (tag.method_10573("visual", 10)) {
            this.loadVisualState(tag.method_10562("visual"));
        }
        super.method_11014(tag);
        this.loadTag(tag);
    }

    public void loadTag(class_2487 data) {
        this.customName = data.method_10545("customName") ? class_2561.method_43470((String)data.method_10558("customName")) : null;
        if (data.method_10573("forward", 8) && data.method_10573("up", 8)) {
            try {
                class_2350 forward = class_2350.valueOf((String)data.method_10558("forward").toUpperCase(Locale.ROOT));
                class_2350 up = class_2350.valueOf((String)data.method_10558("up").toUpperCase(Locale.ROOT));
                this.pendingOrientationChange = BlockOrientation.get(forward, up);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void method_11007(class_2487 data) {
        if (VisualStateSaving.isEnabled(this.field_11863)) {
            class_2487 visualTag = new class_2487();
            this.saveVisualState(visualTag);
            data.method_10566("visual", (class_2520)visualTag);
        }
        super.method_11007(data);
        if (this.customName != null) {
            data.method_10582("customName", this.customName.getString());
        }
    }

    @MustBeInvokedByOverriders
    public void onReady() {
        this.readyInvoked = (byte)(this.readyInvoked + 1);
        if (this.pendingOrientationChange != null) {
            class_2680 state = this.method_11010();
            this.field_11863.method_8501(this.method_11016(), IOrientationStrategy.get(state).setOrientation(state, this.pendingOrientationChange.getSide(RelativeSide.FRONT), this.pendingOrientationChange.getSpin()));
            this.pendingOrientationChange = null;
        }
    }

    protected void scheduleInit() {
        this.queuedForReady = (byte)(this.queuedForReady + 1);
        GridHelper.onFirstTick(this, AEBaseBlockEntity::onReady);
    }

    public class_2487 method_16887() {
        class_2487 data = new class_2487();
        class_2540 stream = new class_2540(Unpooled.buffer());
        this.writeToStream(stream);
        stream.capacity(stream.readableBytes());
        data.method_10570("#upd", stream.array());
        return data;
    }

    private boolean readUpdateData(class_2540 stream) {
        boolean output = false;
        try {
            output = this.readFromStream(stream);
        }
        catch (Throwable t) {
            AELog.warn(t);
        }
        return output;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected boolean readFromStream(class_2540 data) {
        return false;
    }

    protected void writeToStream(class_2540 data) {
    }

    @MustBeInvokedByOverriders
    protected void saveVisualState(class_2487 data) {
    }

    @MustBeInvokedByOverriders
    protected void loadVisualState(class_2487 data) {
    }

    public void markForUpdate() {
        if (this.field_11863 != null && !this.method_11015() && !this.notLoaded()) {
            AEBaseEntityBlock block;
            class_2680 newState;
            boolean alreadyUpdated = false;
            class_2680 currentState = this.method_11010();
            class_2248 class_22482 = currentState.method_26204();
            if (class_22482 instanceof AEBaseEntityBlock && currentState != (newState = (block = (AEBaseEntityBlock)class_22482).getBlockEntityBlockState(currentState, this))) {
                AELog.blockUpdate(this.field_11867, currentState, newState, this);
                this.field_11863.method_8501(this.field_11867, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.field_11863.method_8413(this.field_11867, currentState, currentState, 1);
            }
        }
    }

    public final BlockOrientation getOrientation() {
        return BlockOrientation.get(this.method_11010());
    }

    public class_2350 getFront() {
        return this.getOrientation().getSide(RelativeSide.FRONT);
    }

    public class_2350 getTop() {
        return this.getOrientation().getSide(RelativeSide.TOP);
    }

    @ApiStatus.OverrideOnly
    protected void onOrientationChanged(BlockOrientation orientation) {
    }

    @MustBeInvokedByOverriders
    public void exportSettings(SettingsFrom mode, class_2487 output, @Nullable class_1657 player) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            MemoryCardItem.exportGenericSettings(this, output);
        }
    }

    @MustBeInvokedByOverriders
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        class_2561 customName = CustomNameUtil.getCustomName(input);
        this.customName = customName != null ? class_2561.method_43470((String)customName.getString()) : null;
        MemoryCardItem.importGenericSettings(this, input, player);
    }

    @MustBeInvokedByOverriders
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
    }

    @MustBeInvokedByOverriders
    public void method_5448() {
    }

    public class_2561 method_5477() {
        return Objects.requireNonNullElse(this.customName, this.getItemFromBlockEntity().method_7848());
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public boolean isClientSide() {
        class_1937 level = this.method_10997();
        return level == null || level.method_8608();
    }

    public void saveChanges() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            this.method_5431();
        } else {
            this.field_11863.method_8524(this.field_11867);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private Object setChangedAtEndOfTick(class_1937 level) {
        this.method_5431();
        this.setChangedQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = class_2561.method_43470((String)name);
    }

    @Override
    @Nullable
    @MustBeInvokedByOverriders
    public InternalInventory getSubInventory(class_2960 id) {
        return null;
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return new AEModelData();
    }

    public class_1269 disassembleWithWrench(class_1657 player, class_1937 level, class_3965 hitResult, class_1799 wrench) {
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            List drops = class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)pos, (class_2586)this, (class_1297)player, (class_1799)wrench);
            class_1799 op = new class_1799((class_1935)state.method_26204());
            for (class_1799 ol : drops) {
                if (!ItemComparisonHelper.isEqualItemType(ol, op)) continue;
                class_2487 tag = new class_2487();
                this.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
                if (tag.method_33133()) break;
                ol.method_7980(tag);
                break;
            }
            this.addAdditionalDrops(level, pos, drops);
            this.method_5448();
            for (class_1799 item : drops) {
                player.method_31548().method_7398(item);
            }
        }
        block.method_9576(level, pos, state, player);
        level.method_8650(pos, false);
        block.method_9585((class_1936)level, pos, this.method_11010());
        return class_1269.method_29236((boolean)level.method_8608());
    }

    public byte getQueuedForReady() {
        return this.queuedForReady;
    }

    public byte getReadyInvoked() {
        return this.readyInvoked;
    }

    public void method_31664(class_2680 state) {
        BlockOrientation previousOrientation = BlockOrientation.get(this.method_11010());
        super.method_31664(state);
        BlockOrientation newOrientation = BlockOrientation.get(this.method_11010());
        if (previousOrientation != newOrientation) {
            this.onOrientationChanged(newOrientation);
        }
    }

    static {
        DeferredBlockEntityUnloader.register();
        REPRESENTATIVE_ITEMS = new HashMap();
    }
}

