/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.blockentity.crafting.CraftingCubeModelData;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.util.NullConfigManager;
import appeng.util.Platform;
import appeng.util.iterators.ChainedIterator;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class CraftingBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<CraftingCPUCluster>,
IPowerChannelState,
IConfigurableObject {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private class_2487 previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;

    public CraftingBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL).addService(IGridMultiblock.class, this::getMultiblockNodes);
    }

    @Override
    protected class_1792 getItemFromBlockEntity() {
        if (this.field_11863 == null) {
            return class_1802.field_8162;
        }
        return this.getUnitBlock().type.getItemFromType();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public AbstractCraftingUnitBlock<?> getUnitBlock() {
        if (this.field_11863 == null || this.notLoaded() || this.method_11015()) {
            return AEBlocks.CRAFTING_UNIT.block();
        }
        return (AbstractCraftingUnitBlock)this.field_11863.method_8320(this.field_11867).method_26204();
    }

    public long getStorageBytes() {
        return this.getUnitBlock().type.getStorageBytes();
    }

    public int getAcceleratorThreads() {
        return this.getUnitBlock().type.getAcceleratorThreads();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((class_1935)this.getItemFromBlockEntity());
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.calculateMultiblock(serverLevel, this.field_11867);
        }
    }

    public void updateMultiBlock(class_2338 changedPos) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.field_11867, changedPos);
        }
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        class_2680 newState;
        if (this.field_11863 == null || this.notLoaded() || this.method_11015()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        class_2680 current = this.field_11863.method_8320(this.field_11867);
        if (current.method_26204() instanceof AbstractCraftingUnitBlock && current != (newState = (class_2680)((class_2680)current.method_11657((class_2769)AbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).method_11657((class_2769)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.field_11863.method_8652(this.field_11867, newState, 2);
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return EnumSet.allOf(class_2350.class);
        }
        return EnumSet.noneOf(class_2350.class);
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.method_11010().method_11654((class_2769)AbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10556("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.setCoreBlock(data.method_10577("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.method_10553());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    @Override
    public CraftingCPUCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.cancelJob();
            ListCraftingInventory inv = this.cluster.craftingLogic.getInventory();
            ArrayList<class_2338> places = new ArrayList<class_2338>();
            for (CraftingBlockEntity blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.field_11867);
                    continue;
                }
                for (class_2350 d : class_2350.values()) {
                    class_2338 p = blockEntity.field_11867.method_10093(d);
                    if (!this.field_11863.method_22347(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (Object2LongMap.Entry entry : inv.list) {
                class_2338 position = (class_2338)class_156.method_32309(places, (class_5819)this.field_11863.method_8409());
                ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                ((AEKey)entry.getKey()).addDrops(entry.getLongValue(), stacks, this.field_11863, position);
                Platform.spawnDrops(this.field_11863, position, stacks);
            }
            inv.clear();
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AbstractCraftingUnitBlock.POWERED);
        }
        return this.getMainNode().isActive();
    }

    @Override
    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public class_2487 getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(class_2487 previousState) {
        this.previousState = previousState;
    }

    @Override
    public Object getRenderAttachmentData() {
        return new CraftingCubeModelData(this.getConnections());
    }

    protected EnumSet<class_2350> getConnections() {
        if (this.field_11863 == null) {
            return EnumSet.noneOf(class_2350.class);
        }
        EnumSet<class_2350> connections = EnumSet.noneOf(class_2350.class);
        for (class_2350 facing : class_2350.values()) {
            if (!this.isConnected((class_1922)this.field_11863, this.field_11867, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(class_1922 level, class_2338 pos, class_2350 side) {
        class_2338 adjacentPos = pos.method_10093(side);
        return level.method_8320(adjacentPos).method_26204() instanceof AbstractCraftingUnitBlock;
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator<IGridNode>(new IGridNode[0]);
        }
        return Iterators.transform(this.getCluster().getBlockEntities(), IGridConnectedBlockEntity::getGridNode);
    }

    @Override
    public IConfigManager getConfigManager() {
        CraftingCPUCluster cluster = this.getCluster();
        if (cluster != null) {
            return this.getCluster().getConfigManager();
        }
        return NullConfigManager.INSTANCE;
    }
}

