/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.List;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class VibrationChamberBlockEntity
extends AENetworkInvBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private final InternalInventory invExt = new FilteredInternalInventory(this.inv, new FuelSlotFilter());
    private final IUpgradeInventory upgrades;
    private double currentFuelTicksPerTick;
    private double remainingFuelTicks = 0.0;
    private double fuelItemFuelTicks = 0.0;
    private double minFuelTicksPerTick;
    private double maxFuelTicksPerTick;
    private double initialFuelTicksPerTick;
    public boolean isOn;
    private final double minEnergyRate;
    private final double baseMaxEnergyRate;
    private final double initialEnergyRate;

    public VibrationChamberBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).setFlags(new GridFlags[0]).addService(IGridTickable.class, this);
        this.upgrades = UpgradeInventories.forMachine(AEBlocks.VIBRATION_CHAMBER, 3, this::saveChanges);
        this.minEnergyRate = AEConfig.instance().getVibrationChamberMinEnergyPerGameTick();
        this.baseMaxEnergyRate = AEConfig.instance().getVibrationChamberMaxEnergyPerGameTick();
        this.initialEnergyRate = class_3532.method_15350((double)AEConfig.instance().getVibrationChamberBaseEnergyPerFuelTick(), (double)this.minEnergyRate, (double)this.baseMaxEnergyRate);
        this.minFuelTicksPerTick = this.minEnergyRate / this.getEnergyPerFuelTick();
        this.maxFuelTicksPerTick = this.baseMaxEnergyRate / this.getEnergyPerFuelTick();
        this.currentFuelTicksPerTick = this.initialFuelTicksPerTick = this.initialEnergyRate / this.getEnergyPerFuelTick();
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.isOn = this.getRemainingFuelTicks() > 0.0;
        data.writeBoolean(this.isOn);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.method_10549("burnTime", this.getRemainingFuelTicks());
        data.method_10549("maxBurnTime", this.getFuelItemFuelTicks());
        int speed = (int)(this.currentFuelTicksPerTick * 100.0 / this.maxFuelTicksPerTick);
        data.method_10569("burnSpeed", speed);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.setRemainingFuelTicks(data.method_10574("burnTime"));
        this.setFuelItemFuelTicks(data.method_10574("maxBurnTime"));
        this.setCurrentFuelTicksPerTick((double)data.method_10550("burnSpeed") * this.maxFuelTicksPerTick / 100.0);
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.upgrades.clear();
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Override
    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    @Override
    public InternalInventory getExposedInventoryForSide(class_2350 facing) {
        return this.invExt;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.getRemainingFuelTicks() <= 0.0 && this.canEatFuel()) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
    }

    private boolean canEatFuel() {
        int newBurnTime;
        class_1799 is = this.inv.getStackInSlot(0);
        return !is.method_7960() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.method_7947() > 0;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getRemainingFuelTicks() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber, this.getRemainingFuelTicks() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.minFuelTicksPerTick = this.minEnergyRate / this.getEnergyPerFuelTick();
        this.maxFuelTicksPerTick = this.getMaxFuelTicksPerTick();
        this.initialFuelTicksPerTick = this.initialEnergyRate / this.getEnergyPerFuelTick();
        if (this.getRemainingFuelTicks() <= 0.0) {
            this.eatFuel();
            if (this.getRemainingFuelTicks() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setCurrentFuelTicksPerTick(this.initialFuelTicksPerTick);
            return TickRateModulation.SLEEP;
        }
        double fuelTicksConsumed = (double)ticksSinceLastCall * this.currentFuelTicksPerTick;
        this.setRemainingFuelTicks(this.getRemainingFuelTicks() - fuelTicksConsumed);
        if (this.getRemainingFuelTicks() < 0.0) {
            fuelTicksConsumed += this.getRemainingFuelTicks();
            this.setRemainingFuelTicks(0.0);
        }
        double speedScalingPerTick = (this.maxFuelTicksPerTick - this.minFuelTicksPerTick) / 100.0;
        double speedStep = (double)ticksSinceLastCall * speedScalingPerTick;
        IGrid grid = node.getGrid();
        IEnergyService energy = grid.getEnergyService();
        if (Math.abs(fuelTicksConsumed - 0.0) < 0.01) {
            if (energy.injectPower(1.0, Actionable.SIMULATE) == 0.0) {
                this.setCurrentFuelTicksPerTick(this.getCurrentFuelTicksPerTick() + speedStep);
                return TickRateModulation.FASTER;
            }
            return TickRateModulation.IDLE;
        }
        double newPower = fuelTicksConsumed * this.getEnergyPerFuelTick();
        double overFlow = energy.injectPower(newPower, Actionable.MODULATE);
        if (overFlow > 0.0) {
            this.setCurrentFuelTicksPerTick(this.getCurrentFuelTicksPerTick() - speedStep);
        } else {
            this.setCurrentFuelTicksPerTick(this.getCurrentFuelTicksPerTick() + speedStep);
        }
        return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
    }

    private void eatFuel() {
        int newBurnTime;
        class_1799 is = this.inv.getStackInSlot(0);
        if (!is.method_7960() && (newBurnTime = VibrationChamberBlockEntity.getBurnTime(is)) > 0 && is.method_7947() > 0) {
            this.setRemainingFuelTicks(this.getRemainingFuelTicks() + (double)newBurnTime);
            this.setFuelItemFuelTicks(this.getRemainingFuelTicks());
            class_1792 fuelItem = is.method_7909();
            is.method_7934(1);
            if (is.method_7960()) {
                class_1792 remainder = fuelItem.method_7858();
                if (remainder != null) {
                    this.inv.setItemDirect(0, new class_1799((class_1935)remainder));
                } else {
                    this.inv.setItemDirect(0, class_1799.field_8037);
                }
            } else {
                this.inv.setItemDirect(0, is);
            }
            this.saveChanges();
        }
        if (this.getRemainingFuelTicks() > 0.0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        }
        if (!this.isOn && this.getRemainingFuelTicks() > 0.0 || this.isOn && this.getRemainingFuelTicks() <= 0.0) {
            this.isOn = this.getRemainingFuelTicks() > 0.0;
            this.markForUpdate();
            if (this.method_11002()) {
                Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
            }
        }
    }

    public static int getBurnTime(class_1799 is) {
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)is.method_7909());
        return burnTime != null ? burnTime : 0;
    }

    public static boolean hasBurnTime(class_1799 is) {
        return VibrationChamberBlockEntity.getBurnTime(is) > 0;
    }

    public double getCurrentFuelTicksPerTick() {
        return this.currentFuelTicksPerTick;
    }

    private void setCurrentFuelTicksPerTick(double currentFuelTicksPerTick) {
        this.currentFuelTicksPerTick = class_3532.method_15350((double)currentFuelTicksPerTick, (double)this.minFuelTicksPerTick, (double)this.maxFuelTicksPerTick);
    }

    public double getFuelItemFuelTicks() {
        return this.fuelItemFuelTicks;
    }

    private void setFuelItemFuelTicks(double fuelItemFuelTicks) {
        this.fuelItemFuelTicks = fuelItemFuelTicks;
    }

    public double getRemainingFuelTicks() {
        return this.remainingFuelTicks;
    }

    private void setRemainingFuelTicks(double remainingFuelTicks) {
        this.remainingFuelTicks = remainingFuelTicks;
    }

    public double getEnergyPerFuelTick() {
        return AEConfig.instance().getVibrationChamberBaseEnergyPerFuelTick() * (double)(1.0f + (float)this.upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD) / 2.0f);
    }

    public double getMinFuelTicksPerTick() {
        return this.minFuelTicksPerTick;
    }

    public double getMaxFuelTicksPerTick() {
        return this.getMaxEnergyRate() / this.getEnergyPerFuelTick();
    }

    public double getMaxEnergyRate() {
        return this.baseMaxEnergyRate + this.baseMaxEnergyRate * (double)this.upgrades.getInstalledUpgrades(AEItems.SPEED_CARD) / 2.0;
    }

    private static class FuelSlotFilter
    implements IAEItemFilter {
        private FuelSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return !VibrationChamberBlockEntity.hasBurnTime(inv.getStackInSlot(slot));
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return VibrationChamberBlockEntity.hasBurnTime(stack);
        }
    }
}

