/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.style;

import appeng.client.gui.style.TextureTransform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class Blitter {
    public static final int DEFAULT_TEXTURE_WIDTH = 256;
    public static final int DEFAULT_TEXTURE_HEIGHT = 256;
    private final class_2960 texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private class_768 srcRect;
    private class_768 destRect = new class_768(0, 0, 0, 0);
    private boolean blending = true;
    private TextureTransform transform = TextureTransform.NONE;

    Blitter(class_2960 texture, int referenceWidth, int referenceHeight) {
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
    }

    public static Blitter texture(class_2960 file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(String file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(class_2960 file, int referenceWidth, int referenceHeight) {
        return new Blitter(file, referenceWidth, referenceHeight);
    }

    public static Blitter texture(String file, int referenceWidth, int referenceHeight) {
        return new Blitter(new class_2960("ae2", "textures/" + file), referenceWidth, referenceHeight);
    }

    public static Blitter sprite(class_1058 sprite) {
        int refSize = 0x3FFFFFFF;
        return new Blitter(sprite.method_45852(), 0x3FFFFFFF, 0x3FFFFFFF).src((int)(sprite.method_4594() * 1.0737418E9f), (int)(sprite.method_4593() * 1.0737418E9f), (int)((sprite.method_4577() - sprite.method_4594()) * 1.0737418E9f), (int)((sprite.method_4575() - sprite.method_4593()) * 1.0737418E9f));
    }

    public Blitter copy() {
        Blitter result = new Blitter(this.texture, this.referenceWidth, this.referenceHeight);
        result.srcRect = this.srcRect;
        result.destRect = this.destRect;
        result.r = this.r;
        result.g = this.g;
        result.b = this.b;
        result.a = this.a;
        return result;
    }

    public int getSrcX() {
        return this.srcRect == null ? 0 : this.srcRect.method_3321();
    }

    public int getSrcY() {
        return this.srcRect == null ? 0 : this.srcRect.method_3322();
    }

    public int getSrcWidth() {
        return this.srcRect == null ? this.destRect.method_3319() : this.srcRect.method_3319();
    }

    public int getSrcHeight() {
        return this.srcRect == null ? this.destRect.method_3320() : this.srcRect.method_3320();
    }

    public Blitter src(int x, int y, int w, int h) {
        this.srcRect = new class_768(x, y, w, h);
        return this;
    }

    public Blitter srcWidth(int w) {
        this.srcRect = new class_768(this.srcRect.method_3321(), this.srcRect.method_3322(), w, this.srcRect.method_3320());
        return this;
    }

    public Blitter srcHeight(int h) {
        this.srcRect = new class_768(this.srcRect.method_3321(), this.srcRect.method_3322(), this.srcRect.method_3319(), h);
        return this;
    }

    public Blitter src(class_768 rect) {
        return this.src(rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320());
    }

    public Blitter dest(int x, int y, int w, int h) {
        this.destRect = new class_768(x, y, w, h);
        return this;
    }

    public Blitter dest(int x, int y) {
        return this.dest(x, y, 0, 0);
    }

    public Blitter dest(class_768 rect) {
        return this.dest(rect.method_3321(), rect.method_3322(), rect.method_3319(), rect.method_3320());
    }

    public class_768 getDestRect() {
        int x = this.destRect.method_3321();
        int y = this.destRect.method_3322();
        int w = 0;
        int h = 0;
        if (this.destRect.method_3319() != 0 && this.destRect.method_3320() != 0) {
            w = this.destRect.method_3319();
            h = this.destRect.method_3320();
        } else if (this.srcRect != null) {
            w = this.srcRect.method_3319();
            h = this.srcRect.method_3320();
        }
        return new class_768(x, y, w, h);
    }

    public Blitter color(float r, float g, float b) {
        this.r = (int)(class_3532.method_15363((float)r, (float)0.0f, (float)1.0f) * 255.0f);
        this.g = (int)(class_3532.method_15363((float)g, (float)0.0f, (float)1.0f) * 255.0f);
        this.b = (int)(class_3532.method_15363((float)b, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter colorArgb(int packedArgb) {
        this.a = class_5253.class_5254.method_27762((int)packedArgb);
        this.r = class_5253.class_5254.method_27765((int)packedArgb);
        this.g = class_5253.class_5254.method_27766((int)packedArgb);
        this.b = class_5253.class_5254.method_27767((int)packedArgb);
        return this;
    }

    public Blitter opacity(float a) {
        this.a = (int)(class_3532.method_15363((float)a, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter color(float r, float g, float b, float a) {
        return this.color(r, g, b).opacity(a);
    }

    public Blitter transform(TextureTransform transform) {
        this.transform = Objects.requireNonNull(transform);
        return this;
    }

    public Blitter blending(boolean enable) {
        this.blending = enable;
        return this;
    }

    public Blitter colorRgb(int packedRgb) {
        float r = (float)(packedRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedRgb & 0xFF) / 255.0f;
        return this.color(r, g, b);
    }

    public void blit(class_332 guiGraphics) {
        float maxU;
        float maxV;
        float minU;
        float minV;
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        if (this.srcRect == null) {
            minV = 0.0f;
            minU = 0.0f;
            maxV = 1.0f;
            maxU = 1.0f;
        } else {
            minU = (float)this.srcRect.method_3321() / (float)this.referenceWidth;
            minV = (float)this.srcRect.method_3322() / (float)this.referenceHeight;
            maxU = (float)(this.srcRect.method_3321() + this.srcRect.method_3319()) / (float)this.referenceWidth;
            maxV = (float)(this.srcRect.method_3322() + this.srcRect.method_3320()) / (float)this.referenceHeight;
        }
        switch (this.transform) {
            case MIRROR_H: {
                float tmp = minU;
                minU = maxU;
                maxU = tmp;
                break;
            }
            case MIRROR_V: {
                float tmp = minV;
                minV = maxV;
                maxV = tmp;
            }
        }
        float x1 = this.destRect.method_3321();
        float y1 = this.destRect.method_3322();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.method_3319() != 0 && this.destRect.method_3320() != 0) {
            x2 += (float)this.destRect.method_3319();
            y2 += (float)this.destRect.method_3320();
        } else if (this.srcRect != null) {
            x2 += (float)this.srcRect.method_3319();
            y2 += (float)this.srcRect.method_3320();
        }
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(matrix, x1, y2, 0.0f).method_22913(minU, maxV).method_1336(this.r, this.g, this.b, this.a).method_1344();
        bufferbuilder.method_22918(matrix, x2, y2, 0.0f).method_22913(maxU, maxV).method_1336(this.r, this.g, this.b, this.a).method_1344();
        bufferbuilder.method_22918(matrix, x2, y1, 0.0f).method_22913(maxU, minV).method_1336(this.r, this.g, this.b, this.a).method_1344();
        bufferbuilder.method_22918(matrix, x1, y1, 0.0f).method_22913(minU, minV).method_1336(this.r, this.g, this.b, this.a).method_1344();
        if (this.blending) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            RenderSystem.disableBlend();
        }
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }
}

