/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytVisitor;
import appeng.client.guidebook.document.flow.LytFlowAnchor;
import appeng.client.guidebook.document.flow.LytFlowContent;
import java.util.Locale;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public final class AnchorIndexer {
    private final LytDocument document;

    public AnchorIndexer(LytDocument document) {
        this.document = document;
    }

    public AnchorTarget get(final String anchor) {
        var visitor = new LytVisitor(){
            final Stack<LytNode> nodeStack = new Stack();
            AnchorTarget target;

            @Override
            public LytVisitor.Result beforeNode(LytNode node) {
                LytHeading heading;
                String headingAnchor;
                if (node instanceof LytHeading && (headingAnchor = AnchorIndexer.this.normalizeAnchor((heading = (LytHeading)node).getTextContent())).equals(anchor)) {
                    this.target = new AnchorTarget(node, null);
                    return LytVisitor.Result.STOP;
                }
                this.nodeStack.push(node);
                return LytVisitor.Result.CONTINUE;
            }

            @Override
            public LytVisitor.Result afterNode(LytNode node) {
                this.nodeStack.pop();
                return LytVisitor.Result.CONTINUE;
            }

            @Override
            public LytVisitor.Result beforeFlowContent(LytFlowContent content) {
                LytFlowAnchor flowAnchor;
                if (content instanceof LytFlowAnchor && anchor.equals((flowAnchor = (LytFlowAnchor)content).getName())) {
                    this.target = new AnchorTarget(this.nodeStack.peek(), content);
                    return LytVisitor.Result.STOP;
                }
                return LytVisitor.Result.CONTINUE;
            }
        };
        this.document.visit(visitor);
        return visitor.target;
    }

    private String normalizeAnchor(String anchor) {
        return anchor.toLowerCase(Locale.ROOT).trim().replaceAll("\\s+", "-");
    }

    public record AnchorTarget(LytNode blockNode, @Nullable LytFlowContent flowContent) {
    }
}

