/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.compiler.Frontmatter;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.LinkParser;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.compiler.TagCompiler;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytImage;
import appeng.client.guidebook.document.block.LytList;
import appeng.client.guidebook.document.block.LytListItem;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.block.LytThematicBreak;
import appeng.client.guidebook.document.block.table.LytTable;
import appeng.client.guidebook.document.block.table.LytTableCell;
import appeng.client.guidebook.document.block.table.LytTableRow;
import appeng.client.guidebook.document.flow.LytFlowBreak;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowInlineBlock;
import appeng.client.guidebook.document.flow.LytFlowLink;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.document.flow.LytFlowText;
import appeng.client.guidebook.document.interaction.TextTooltip;
import appeng.client.guidebook.extensions.Extension;
import appeng.client.guidebook.extensions.ExtensionCollection;
import appeng.client.guidebook.extensions.ExtensionPoint;
import appeng.client.guidebook.indices.PageIndex;
import appeng.client.guidebook.style.TextAlignment;
import appeng.client.guidebook.style.WhiteSpaceMode;
import appeng.libs.mdast.MdAst;
import appeng.libs.mdast.MdAstYamlFrontmatter;
import appeng.libs.mdast.MdastOptions;
import appeng.libs.mdast.YamlFrontmatterExtension;
import appeng.libs.mdast.gfm.GfmTableMdastExtension;
import appeng.libs.mdast.gfm.model.GfmTable;
import appeng.libs.mdast.gfm.model.GfmTableRow;
import appeng.libs.mdast.mdx.MdxMdastExtension;
import appeng.libs.mdast.mdx.model.MdxJsxFlowElement;
import appeng.libs.mdast.mdx.model.MdxJsxTextElement;
import appeng.libs.mdast.model.MdAstAnyContent;
import appeng.libs.mdast.model.MdAstBreak;
import appeng.libs.mdast.model.MdAstCode;
import appeng.libs.mdast.model.MdAstEmphasis;
import appeng.libs.mdast.model.MdAstHeading;
import appeng.libs.mdast.model.MdAstImage;
import appeng.libs.mdast.model.MdAstInlineCode;
import appeng.libs.mdast.model.MdAstLink;
import appeng.libs.mdast.model.MdAstList;
import appeng.libs.mdast.model.MdAstListContent;
import appeng.libs.mdast.model.MdAstListItem;
import appeng.libs.mdast.model.MdAstNode;
import appeng.libs.mdast.model.MdAstParagraph;
import appeng.libs.mdast.model.MdAstParent;
import appeng.libs.mdast.model.MdAstPhrasingContent;
import appeng.libs.mdast.model.MdAstPosition;
import appeng.libs.mdast.model.MdAstRoot;
import appeng.libs.mdast.model.MdAstStrong;
import appeng.libs.mdast.model.MdAstText;
import appeng.libs.mdast.model.MdAstThematicBreak;
import appeng.libs.mdx.MdxSyntax;
import appeng.libs.micromark.extensions.YamlFrontmatterSyntax;
import appeng.libs.micromark.extensions.gfm.GfmTableSyntax;
import appeng.libs.unist.UnistNode;
import appeng.libs.unist.UnistPoint;
import appeng.libs.unist.UnistPosition;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class PageCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageCompiler.class);
    private static final int DEFAULT_ELEMENT_SPACING = 5;
    private final PageCollection pages;
    private final ExtensionCollection extensions;
    private final String sourcePack;
    private final class_2960 pageId;
    private final String pageContent;
    private final Map<String, TagCompiler> tagCompilers = new HashMap<String, TagCompiler>();
    private final Map<State<?>, Object> compilerState = new IdentityHashMap();

    public PageCompiler(PageCollection pages, ExtensionCollection extensions, String sourcePack, class_2960 pageId, String pageContent) {
        this.pages = pages;
        this.extensions = extensions;
        this.sourcePack = sourcePack;
        this.pageId = pageId;
        this.pageContent = pageContent;
        for (TagCompiler tagCompiler : extensions.get(TagCompiler.EXTENSION_POINT)) {
            for (String tagName : tagCompiler.getTagNames()) {
                this.tagCompilers.put(tagName, tagCompiler);
            }
        }
    }

    public static ParsedGuidePage parse(String sourcePack, class_2960 id, InputStream in) throws IOException {
        String pageContent = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        return PageCompiler.parse(sourcePack, id, pageContent);
    }

    public static ParsedGuidePage parse(String sourcePack, class_2960 id, String pageContent) {
        pageContent = pageContent.replaceAll("\\r\\n?", "\n");
        MdastOptions options = new MdastOptions().withSyntaxExtension(MdxSyntax.INSTANCE).withSyntaxExtension(YamlFrontmatterSyntax.INSTANCE).withSyntaxExtension(GfmTableSyntax.INSTANCE).withMdastExtension(MdxMdastExtension.INSTANCE).withMdastExtension(YamlFrontmatterExtension.INSTANCE).withMdastExtension(GfmTableMdastExtension.INSTANCE);
        MdAstRoot astRoot = MdAst.fromMarkdown(pageContent, options);
        Frontmatter frontmatter = PageCompiler.parseFrontmatter(id, astRoot);
        return new ParsedGuidePage(sourcePack, id, pageContent, astRoot, frontmatter);
    }

    public static GuidePage compile(PageCollection pages, ExtensionCollection extensions, ParsedGuidePage parsedPage) {
        LytDocument document = new PageCompiler(pages, extensions, parsedPage.sourcePack, parsedPage.id, parsedPage.source).compile(parsedPage.astRoot);
        return new GuidePage(parsedPage.sourcePack, parsedPage.id, document);
    }

    public ExtensionCollection getExtensions() {
        return this.extensions;
    }

    public <T extends Extension> List<T> getExtensions(ExtensionPoint<T> extensionPoint) {
        return this.extensions.get(extensionPoint);
    }

    private LytDocument compile(MdAstRoot root) {
        LytDocument document = new LytDocument();
        document.setSourceNode(root);
        this.compileBlockContext(root, (LytBlockContainer)document);
        return document;
    }

    private static Frontmatter parseFrontmatter(class_2960 pageId, MdAstRoot root) {
        Frontmatter result = null;
        for (MdAstAnyContent child : root.children()) {
            if (!(child instanceof MdAstYamlFrontmatter)) continue;
            MdAstYamlFrontmatter frontmatter = (MdAstYamlFrontmatter)child;
            if (result != null) {
                LOGGER.error("Found more than one frontmatter!");
                continue;
            }
            try {
                result = Frontmatter.parse(pageId, frontmatter.value);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse frontmatter for page {}", (Object)pageId, (Object)e);
                break;
            }
        }
        return Objects.requireNonNullElse(result, new Frontmatter(null, Map.of()));
    }

    public void compileBlockContext(MdAstParent<?> markdownParent, LytBlockContainer layoutParent) {
        this.compileBlockContext(markdownParent.children(), layoutParent);
    }

    public void compileBlockContext(List<? extends MdAstAnyContent> children, LytBlockContainer layoutParent) {
        LytThematicBreak previousLayoutChild = null;
        for (MdAstAnyContent mdAstAnyContent : children) {
            LytBlock layoutChild;
            if (mdAstAnyContent instanceof MdAstThematicBreak) {
                layoutChild = new LytThematicBreak();
            } else if (mdAstAnyContent instanceof MdAstList) {
                MdAstList astList = (MdAstList)mdAstAnyContent;
                layoutChild = this.compileList(astList);
            } else if (mdAstAnyContent instanceof MdAstCode) {
                MdAstCode astCode = (MdAstCode)mdAstAnyContent;
                paragraph = new LytParagraph();
                paragraph.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
                paragraph.setMarginLeft(5);
                paragraph.appendText(astCode.value);
                layoutChild = paragraph;
            } else if (mdAstAnyContent instanceof MdAstHeading) {
                MdAstHeading astHeading = (MdAstHeading)mdAstAnyContent;
                LytHeading heading = new LytHeading();
                heading.setDepth(astHeading.depth);
                this.compileFlowContext(astHeading, (LytFlowParent)heading);
                layoutChild = heading;
            } else if (mdAstAnyContent instanceof MdAstParagraph) {
                MdAstParagraph astParagraph = (MdAstParagraph)mdAstAnyContent;
                paragraph = new LytParagraph();
                this.compileFlowContext(astParagraph, (LytFlowParent)paragraph);
                paragraph.setMarginTop(5);
                paragraph.setMarginBottom(5);
                layoutChild = paragraph;
            } else if (mdAstAnyContent instanceof MdAstYamlFrontmatter) {
                layoutChild = null;
            } else if (mdAstAnyContent instanceof GfmTable) {
                GfmTable astTable = (GfmTable)mdAstAnyContent;
                layoutChild = this.compileTable(astTable);
            } else if (mdAstAnyContent instanceof MdxJsxFlowElement) {
                MdxJsxFlowElement el = (MdxJsxFlowElement)mdAstAnyContent;
                TagCompiler compiler = this.tagCompilers.get(el.name());
                if (compiler == null) {
                    layoutChild = this.createErrorBlock("Unhandled MDX element in block context", mdAstAnyContent);
                } else {
                    layoutChild = null;
                    compiler.compileBlockContext(this, layoutParent, el);
                }
            } else if (mdAstAnyContent instanceof MdAstPhrasingContent) {
                MdAstPhrasingContent phrasingContent = (MdAstPhrasingContent)mdAstAnyContent;
                if (previousLayoutChild instanceof LytParagraph) {
                    paragraph = (LytParagraph)((Object)previousLayoutChild);
                    this.compileFlowContent(paragraph, phrasingContent);
                    continue;
                }
                LytParagraph paragraph = new LytParagraph();
                this.compileFlowContent(paragraph, phrasingContent);
                layoutChild = paragraph;
            } else {
                layoutChild = this.createErrorBlock("Unhandled Markdown node in block context", mdAstAnyContent);
            }
            if (layoutChild != null) {
                if (mdAstAnyContent instanceof MdAstNode) {
                    MdAstNode astNode = (MdAstNode)((Object)mdAstAnyContent);
                    layoutChild.setSourceNode(astNode);
                }
                layoutParent.append(layoutChild);
            }
            previousLayoutChild = layoutChild;
        }
    }

    private LytList compileList(MdAstList astList) {
        LytList list = new LytList(astList.ordered, astList.start);
        for (MdAstListContent listContent : astList.children()) {
            if (listContent instanceof MdAstListItem) {
                LytNode firstChild;
                MdAstListItem astListItem = (MdAstListItem)listContent;
                LytListItem listItem = new LytListItem();
                this.compileBlockContext(astListItem, (LytBlockContainer)listItem);
                List<? extends LytNode> children = listItem.getChildren();
                if (!children.isEmpty() && (firstChild = children.get(0)) instanceof LytBlock) {
                    LytBlock firstBlock = (LytBlock)firstChild;
                    firstBlock.setMarginTop(0);
                    firstBlock.setMarginBottom(0);
                }
                list.append(listItem);
                continue;
            }
            list.append(this.createErrorBlock("Cannot handle list content", listContent));
        }
        return list;
    }

    private LytBlock compileTable(GfmTable astTable) {
        LytTable table = new LytTable();
        table.setMarginBottom(5);
        boolean firstRow = true;
        for (GfmTableRow astRow : astTable.children()) {
            LytTableRow row = table.appendRow();
            if (firstRow) {
                row.modifyStyle(style -> style.bold(true));
                firstRow = false;
            }
            List astCells = astRow.children();
            for (int i = 0; i < astCells.size(); ++i) {
                LytTableCell cell = row.appendCell();
                if (astTable.align != null && i < astTable.align.size()) {
                    switch (astTable.align.get(i)) {
                        case CENTER: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.CENTER));
                            break;
                        }
                        case RIGHT: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.RIGHT));
                        }
                    }
                }
                this.compileBlockContext((MdAstParent)astCells.get(i), (LytBlockContainer)cell);
            }
        }
        return table;
    }

    public void compileFlowContext(MdAstParent<?> markdownParent, LytFlowParent layoutParent) {
        this.compileFlowContext(markdownParent.children(), layoutParent);
    }

    public void compileFlowContext(Collection<? extends MdAstAnyContent> children, LytFlowParent layoutParent) {
        for (MdAstAnyContent mdAstAnyContent : children) {
            this.compileFlowContent(layoutParent, mdAstAnyContent);
        }
    }

    private void compileFlowContent(LytFlowParent layoutParent, MdAstAnyContent content) {
        LytFlowContent layoutChild;
        if (content instanceof MdAstText) {
            MdAstText astText = (MdAstText)content;
            LytFlowText text = new LytFlowText();
            text.setText(astText.value);
            layoutChild = text;
        } else if (content instanceof MdAstInlineCode) {
            MdAstInlineCode astCode = (MdAstInlineCode)content;
            LytFlowText text = new LytFlowText();
            text.setText(astCode.value);
            text.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
            layoutChild = text;
        } else if (content instanceof MdAstStrong) {
            MdAstStrong astStrong = (MdAstStrong)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.bold(true));
            this.compileFlowContext(astStrong, (LytFlowParent)span);
            layoutChild = span;
        } else if (content instanceof MdAstEmphasis) {
            MdAstEmphasis astEmphasis = (MdAstEmphasis)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.italic(true));
            this.compileFlowContext(astEmphasis, (LytFlowParent)span);
            layoutChild = span;
        } else if (content instanceof MdAstBreak) {
            layoutChild = new LytFlowBreak();
        } else if (content instanceof MdAstLink) {
            MdAstLink astLink = (MdAstLink)content;
            layoutChild = this.compileLink(astLink, layoutParent);
        } else if (content instanceof MdAstImage) {
            MdAstImage astImage = (MdAstImage)content;
            LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
            inlineBlock.setBlock(this.compileImage(astImage));
            layoutChild = inlineBlock;
        } else if (content instanceof MdxJsxTextElement) {
            MdxJsxTextElement el = (MdxJsxTextElement)content;
            TagCompiler compiler = this.tagCompilers.get(el.name());
            if (compiler == null) {
                layoutChild = this.createErrorFlowContent("Unhandled MDX element in flow context", content);
            } else {
                layoutChild = null;
                compiler.compileFlowContext(this, layoutParent, el);
            }
        } else {
            layoutChild = this.createErrorFlowContent("Unhandled Markdown node in flow context", content);
        }
        if (layoutChild != null) {
            layoutParent.append(layoutChild);
        }
    }

    private LytFlowContent compileLink(final MdAstLink astLink, final LytErrorSink errorSink) {
        final LytFlowLink link = new LytFlowLink();
        if (astLink.title != null && !astLink.title.isEmpty()) {
            link.setTooltip(new TextTooltip(astLink.title));
        }
        if (astLink.url != null && !astLink.url.isEmpty()) {
            LinkParser.parseLink(this, astLink.url, new LinkParser.Visitor(){

                @Override
                public void handlePage(PageAnchor page) {
                    link.setPageLink(page);
                }

                @Override
                public void handleExternal(URI uri) {
                    link.setExternalUrl(uri);
                }

                @Override
                public void handleError(String error) {
                    errorSink.appendError(PageCompiler.this, error, astLink);
                }
            });
        }
        this.compileFlowContext(astLink, (LytFlowParent)link);
        return link;
    }

    @NotNull
    private LytImage compileImage(MdAstImage astImage) {
        LytImage image = new LytImage();
        image.setTitle(astImage.title);
        image.setAlt(astImage.alt);
        try {
            class_2960 imageId = IdUtils.resolveLink(astImage.url, this.pageId);
            byte[] imageContent = this.pages.loadAsset(imageId);
            if (imageContent == null) {
                LOGGER.error("Couldn't find image {}", (Object)astImage.url);
                image.setTitle("Missing image: " + astImage.url);
            }
            image.setImage(imageId, imageContent);
        }
        catch (class_151 e) {
            LOGGER.error("Invalid image id: {}", (Object)astImage.url);
            image.setTitle("Invalid image URL: " + astImage.url);
        }
        return image;
    }

    public LytBlock createErrorBlock(String text, UnistNode child) {
        LytParagraph paragraph = new LytParagraph();
        paragraph.append(this.createErrorFlowContent(text, child));
        return paragraph;
    }

    public LytFlowContent createErrorFlowContent(String text, UnistNode child) {
        LytFlowSpan span = new LytFlowSpan();
        span.modifyStyle(style -> style.color(SymbolicColor.ERROR_TEXT).whiteSpace(WhiteSpaceMode.PRE));
        UnistPosition position = child.position();
        if (position != null) {
            UnistPoint pos = position.start();
            int startOfLine = this.pageContent.lastIndexOf(10, pos.offset()) + 1;
            int endOfLine = this.pageContent.indexOf(10, pos.offset() + 1);
            if (endOfLine == -1) {
                endOfLine = this.pageContent.length();
            }
            String line = this.pageContent.substring(startOfLine, endOfLine);
            text = (String)text + " " + child.type() + " (" + MdAstPosition.stringify(pos) + ")";
            span.appendText((String)text);
            span.appendBreak();
            span.appendText(line);
            span.appendBreak();
            span.appendText("~".repeat(pos.column() - 1) + "^");
            span.appendBreak();
            LOGGER.warn("{}\n{}\n{}\n", new Object[]{text, line, "~".repeat(pos.column() - 1) + "^"});
        } else {
            LOGGER.warn("{}\n", text);
        }
        return span;
    }

    public class_2960 resolveId(String idText) {
        return IdUtils.resolveId(idText, this.pageId.method_12836());
    }

    public class_2960 getPageId() {
        return this.pageId;
    }

    public PageCollection getPageCollection() {
        return this.pages;
    }

    public byte @Nullable [] loadAsset(class_2960 imageId) {
        return this.pages.loadAsset(imageId);
    }

    public <T extends PageIndex> T getIndex(Class<T> clazz) {
        return this.pages.getIndex(clazz);
    }

    public <T> T getCompilerState(State<T> state) {
        Object current = this.compilerState.getOrDefault(state, state.defaultValue);
        return state.dataClass.cast(current);
    }

    public <T> void setCompilerState(State<T> state, T value) {
        this.compilerState.put(state, value);
    }

    public <T> void clearCompilerState(State<T> state) {
        this.compilerState.remove(state);
    }

    public record State<T>(String name, Class<T> dataClass, T defaultValue) {
    }
}

