/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.libs.mdast.mdx.model.MdxJsxAttribute;
import appeng.libs.mdast.mdx.model.MdxJsxAttributeNode;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5253;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class MdxAttrs {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^#([0-9a-fA-F]{2}){3,4}$");

    private MdxAttrs() {
    }

    @Nullable
    public static class_2960 getRequiredId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        String id = el.getAttributeString(attribute, null);
        if (id == null) {
            errorSink.appendError(compiler, "Missing " + attribute + " attribute.", el);
            return null;
        }
        id = id.trim();
        try {
            return compiler.resolveId(id);
        }
        catch (class_151 e) {
            errorSink.appendError(compiler, "Malformed id " + id + ": " + e.getMessage(), el);
            return null;
        }
    }

    @Nullable
    public static Pair<class_2960, class_2248> getRequiredBlockAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        class_2960 itemId = MdxAttrs.getRequiredId(compiler, errorSink, el, attribute);
        class_2248 resultItem = class_7923.field_41175.method_17966(itemId).orElse(null);
        if (resultItem == null) {
            errorSink.appendError(compiler, "Missing block: " + itemId, el);
            return null;
        }
        return Pair.of((Object)itemId, (Object)resultItem);
    }

    @Nullable
    public static Pair<class_2960, class_1792> getRequiredItemAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        class_2960 itemId = MdxAttrs.getRequiredId(compiler, errorSink, el, attribute);
        class_1792 resultItem = class_7923.field_41178.method_17966(itemId).orElse(null);
        if (resultItem == null) {
            errorSink.appendError(compiler, "Missing item: " + itemId, el);
            return null;
        }
        return Pair.of((Object)itemId, (Object)resultItem);
    }

    public static class_1792 getRequiredItem(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        Pair<class_2960, class_1792> result = MdxAttrs.getRequiredItemAndId(compiler, errorSink, el, attribute);
        if (result != null) {
            return (class_1792)result.getRight();
        }
        return null;
    }

    public static float getFloat(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, float defaultValue) {
        String attrValue = el.getAttributeString(name, null);
        if (attrValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(attrValue);
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed floating point value: '" + attrValue + "'", el);
            return defaultValue;
        }
    }

    @Contract(value="_, _, _, _, !null -> !null")
    @Nullable
    public static Vector3f getVector3(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, @Nullable Vector3fc defaultValue) {
        String attrValue = el.getAttributeString(name, null);
        if (attrValue == null) {
            return defaultValue != null ? new Vector3f(defaultValue) : null;
        }
        String[] parts = attrValue.trim().split("\\s+", 3);
        Vector3f result = new Vector3f();
        try {
            for (int i = 0; i < parts.length; ++i) {
                float v = Float.parseFloat(parts[i]);
                result.setComponent(i, v);
            }
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed 3D vector: '" + attrValue + "'", el);
            return defaultValue != null ? new Vector3f(defaultValue) : null;
        }
        return result;
    }

    @Contract(value="_, _, _, _, !null -> !null")
    @Nullable
    public static Vector2f getVector2(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, @Nullable Vector2fc defaultValue) {
        String attrValue = el.getAttributeString(name, null);
        if (attrValue == null) {
            return defaultValue != null ? new Vector2f(defaultValue) : null;
        }
        String[] parts = attrValue.trim().split("\\s+", 2);
        Vector2f result = new Vector2f();
        try {
            for (int i = 0; i < parts.length; ++i) {
                float v = Float.parseFloat(parts[i]);
                result.setComponent(i, v);
            }
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed 2D vector: '" + attrValue + "'", el);
            return defaultValue != null ? new Vector2f(defaultValue) : null;
        }
        return result;
    }

    public static int getInt(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, int defaultValue) {
        String attrValue = el.getAttributeString(name, null);
        if (attrValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed integer value: '" + attrValue + "'", el);
            return defaultValue;
        }
    }

    @Nullable
    public static <T extends Enum<T>> T getEnum(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, T defaultValue) {
        String stringValue = el.getAttributeString(name, ((class_3542)defaultValue).method_15434());
        Class<?> clazz = defaultValue.getClass();
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (!((class_3542)constant).method_15434().equals(stringValue)) continue;
            return (T)constant;
        }
        errorSink.appendError(compiler, "Unrecognized option for attribute " + name + ": " + stringValue, el);
        return null;
    }

    public static class_2680 applyBlockStateProperties(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, class_2680 state) {
        for (MdxJsxAttributeNode attrNode : el.attributes()) {
            if (!(attrNode instanceof MdxJsxAttribute)) continue;
            MdxJsxAttribute attr = (MdxJsxAttribute)attrNode;
            String attrName = attr.name;
            if (!attrName.startsWith("p:")) continue;
            String statePropertyName = attrName.substring("p:".length());
            class_2689 stateDefinition = state.method_26204().method_9595();
            class_2769 property = stateDefinition.method_11663(statePropertyName);
            if (property == null) {
                errorSink.appendError(compiler, "block doesn't have property " + statePropertyName, el);
                continue;
            }
            state = MdxAttrs.applyProperty(compiler, errorSink, el, state, property, attr.getStringValue());
        }
        return state;
    }

    private static <T extends Comparable<T>> class_2680 applyProperty(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, class_2680 state, class_2769<T> property, String stringValue) {
        Optional propertyValue = property.method_11900(stringValue);
        if (propertyValue.isEmpty()) {
            errorSink.appendError(compiler, "Invalid value  for property " + property + ": " + stringValue, el);
            return state;
        }
        return (class_2680)state.method_11657(property, (Comparable)propertyValue.get());
    }

    public static class_2338 getPos(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        int x = MdxAttrs.getInt(compiler, errorSink, el, "x", 0);
        int y = MdxAttrs.getInt(compiler, errorSink, el, "y", 0);
        int z = MdxAttrs.getInt(compiler, errorSink, el, "z", 0);
        return new class_2338(x, y, z);
    }

    public static ColorValue getColor(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, ColorValue defaultColor) {
        String colorStr = el.getAttributeString(name, null);
        if (colorStr != null) {
            int b;
            int g;
            int r;
            if ("transparent".equals(colorStr)) {
                return new ConstantColor(0);
            }
            Matcher m = COLOR_PATTERN.matcher(colorStr);
            if (!m.matches()) {
                errorSink.appendError(compiler, "Color must have format #AARRGGBB", el);
                return defaultColor;
            }
            int a = 255;
            if (colorStr.length() == 7) {
                r = Integer.valueOf(colorStr.substring(1, 3), 16);
                g = Integer.valueOf(colorStr.substring(3, 5), 16);
                b = Integer.valueOf(colorStr.substring(5, 7), 16);
            } else {
                a = Integer.valueOf(colorStr.substring(1, 3), 16);
                r = Integer.valueOf(colorStr.substring(3, 5), 16);
                g = Integer.valueOf(colorStr.substring(5, 7), 16);
                b = Integer.valueOf(colorStr.substring(7, 9), 16);
            }
            return new ConstantColor(class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b));
        }
        return defaultColor;
    }

    public static boolean getBoolean(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, boolean defaultValue) {
        MdxJsxAttribute attribute = el.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.hasExpressionValue()) {
            String expressionValue = attribute.getExpressionValue();
            if (expressionValue.equals("true")) {
                return true;
            }
            if (expressionValue.equals("false")) {
                return false;
            }
        }
        errorSink.appendError(compiler, name + " should be {true} or {false}", el);
        return defaultValue;
    }
}

