/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytAxis;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import net.minecraft.class_4597;
import org.joml.Vector2i;

public abstract class LytBlock
extends LytNode {
    protected LytRect bounds = LytRect.empty();
    private int marginTop;
    private int marginLeft;
    private int marginRight;
    private int marginBottom;

    @Override
    public LytRect getBounds() {
        return this.bounds;
    }

    public boolean isCulled(LytRect viewport) {
        return !viewport.intersects(this.bounds);
    }

    public final void setLayoutPos(Vector2i point) {
        int deltaX = point.x - this.bounds.x();
        int deltaY = point.y - this.bounds.y();
        if (deltaX != 0 || deltaY != 0) {
            this.bounds = this.bounds.withX(point.x).withY(point.y);
            this.onLayoutMoved(deltaX, deltaY);
        }
    }

    public final LytRect layout(LayoutContext context, int x, int y, int availableWidth) {
        this.bounds = this.computeLayout(context, x, y, availableWidth);
        return this.bounds;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginStart(LytAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case LytAxis.HORIZONTAL -> this.getMarginLeft();
            case LytAxis.VERTICAL -> this.getMarginTop();
        };
    }

    public int getMarginEnd(LytAxis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case LytAxis.HORIZONTAL -> this.getMarginRight();
            case LytAxis.VERTICAL -> this.getMarginBottom();
        };
    }

    protected abstract LytRect computeLayout(LayoutContext var1, int var2, int var3, int var4);

    protected abstract void onLayoutMoved(int var1, int var2);

    public abstract void renderBatch(RenderContext var1, class_4597 var2);

    public abstract void render(RenderContext var1);
}

