/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.parts.CableRenderMode;
import appeng.client.EffectType;
import appeng.client.Hotkeys;
import appeng.client.commands.ClientCommands;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.gui.style.StyleManager;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.command.GuidebookStructureCommands;
import appeng.client.guidebook.compiler.TagCompiler;
import appeng.client.guidebook.extensions.ConfigValueTagExtension;
import appeng.client.guidebook.hotkey.OpenGuideHotkey;
import appeng.client.guidebook.scene.ImplicitAnnotationStrategy;
import appeng.client.guidebook.scene.PartAnnotationStrategy;
import appeng.client.guidebook.screen.GlobalInMemoryHistory;
import appeng.client.guidebook.screen.GuideScreen;
import appeng.client.render.StorageCellClientTooltipComponent;
import appeng.client.render.effects.EnergyParticleData;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.overlay.OverlayManager;
import appeng.core.AEConfig;
import appeng.core.AppEngBase;
import appeng.core.definitions.AEBlocks;
import appeng.core.sync.network.ClientNetworkHandler;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.MouseWheelPacket;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.BlockAttackHook;
import appeng.hooks.ICustomPickBlock;
import appeng.hooks.MouseWheelScrolled;
import appeng.hooks.RenderBlockOutlineHook;
import appeng.init.client.InitAdditionalModels;
import appeng.init.client.InitBlockColors;
import appeng.init.client.InitBlockEntityRenderers;
import appeng.init.client.InitBuiltInModels;
import appeng.init.client.InitEntityLayerDefinitions;
import appeng.init.client.InitEntityRendering;
import appeng.init.client.InitItemColors;
import appeng.init.client.InitItemModelsProperties;
import appeng.init.client.InitParticleFactories;
import appeng.init.client.InitRenderTypes;
import appeng.init.client.InitScreens;
import appeng.init.client.InitStackRenderHandlers;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.siteexport.SiteExporter;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4066;
import net.minecraft.class_437;
import net.minecraft.class_5601;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class AppEngClient
extends AppEngBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEngClient.class);
    private static AppEngClient INSTANCE;
    private CableRenderMode prevCableRenderMode = CableRenderMode.STANDARD;
    private final Guide guide;

    public AppEngClient() {
        this.registerParticleFactories();
        this.modelRegistryEvent();
        this.registerBlockColors();
        this.registerItemColors();
        this.registerEntityRenderers();
        this.registerEntityLayerDefinitions();
        this.registerClientTooltipComponents();
        this.registerClientCommands();
        ClientPickBlockGatherCallback.EVENT.register(this::onPickBlock);
        ClientTickEvents.START_CLIENT_TICK.register(this::updateCableRenderMode);
        BlockAttackHook.install();
        RenderBlockOutlineHook.install();
        this.guide = this.createGuide();
        OpenGuideHotkey.init();
        ClientLifecycleEvents.CLIENT_STARTED.register(this::clientSetup);
        INSTANCE = this;
        this.notifyAddons("client");
        ClientTickEvents.END_CLIENT_TICK.register(c -> Hotkeys.checkHotkeys());
        ClientTickEvents.END_CLIENT_TICK.register(this::tickPinnedKeys);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            PendingCraftingJobs.clearPendingJobs();
            PinnedKeys.clearPinnedKeys();
        });
        AppEngClient.registerTests();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            SiteExporter.initialize();
        }
    }

    private void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder builder = ClientCommandManager.literal((String)"ae2client");
            if (AEConfig.instance().isDebugToolsEnabled()) {
                for (ClientCommands.CommandBuilder commandBuilder : ClientCommands.DEBUG_COMMANDS) {
                    commandBuilder.build((LiteralArgumentBuilder<FabricClientCommandSource>)builder);
                }
            }
            dispatcher.register(builder);
        });
    }

    private Guide createGuide() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CommandDispatcher dispatcher = server.method_3734().method_9235();
            GuidebookStructureCommands.register((CommandDispatcher<class_2168>)dispatcher);
        });
        return Guide.builder("ae2", "ae2guide").extension(ImplicitAnnotationStrategy.EXTENSION_POINT, new PartAnnotationStrategy()).extension(TagCompiler.EXTENSION_POINT, new ConfigValueTagExtension()).build();
    }

    private void tickPinnedKeys(class_310 minecraft) {
        if (minecraft.field_1755 == null) {
            PinnedKeys.prune();
        }
    }

    @Override
    public class_1937 getClientLevel() {
        return class_310.method_1551().field_1687;
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    public static AppEngClient instance() {
        return Objects.requireNonNull(INSTANCE, "AppEngClient is not initialized");
    }

    public void registerParticleFactories() {
        InitParticleFactories.init();
    }

    public void registerBlockColors() {
        InitBlockColors.init((arg_0, arg_1) -> ((ColorProviderRegistry)ColorProviderRegistry.BLOCK).register(arg_0, arg_1));
    }

    public void registerItemColors() {
        InitItemColors.init((arg_0, arg_1) -> ((ColorProviderRegistry)ColorProviderRegistry.ITEM).register(arg_0, arg_1));
    }

    private void registerClientTooltipComponents() {
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof StorageCellTooltipComponent) {
                StorageCellTooltipComponent cellTooltipComponent = (StorageCellTooltipComponent)data;
                return new StorageCellClientTooltipComponent(cellTooltipComponent);
            }
            return null;
        });
    }

    private void clientSetup(class_310 client) {
        this.postClientSetup(client);
        MouseWheelScrolled.EVENT.register(this::wheelEvent);
        WorldRenderEvents.LAST.register(OverlayManager.getInstance()::renderWorldLastEvent);
    }

    private void registerEntityRenderers() {
        InitEntityRendering.init(EntityRendererRegistry::register);
    }

    private void registerEntityLayerDefinitions() {
        InitEntityLayerDefinitions.init((modelLayerLocation, layerDefinition) -> EntityModelLayerRegistry.registerModelLayer((class_5601)modelLayerLocation, () -> layerDefinition));
    }

    private void postClientSetup(class_310 minecraft) {
        StyleManager.initialize(minecraft.method_1478());
        InitScreens.init();
        InitStackRenderHandlers.init();
    }

    @Environment(value=EnvType.CLIENT)
    public void modelRegistryEvent() {
        InitAdditionalModels.init();
        InitBlockEntityRenderers.init();
        InitItemModelsProperties.init();
        InitRenderTypes.init();
        InitBuiltInModels.init();
    }

    private boolean wheelEvent(double verticalAmount) {
        if (verticalAmount == 0.0) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (InteractionUtil.isInAlternateUseMode((class_1657)player)) {
            boolean mainHand = player.method_5998(class_1268.field_5808).method_7909() instanceof IMouseWheelItem;
            boolean offHand = player.method_5998(class_1268.field_5810).method_7909() instanceof IMouseWheelItem;
            if (mainHand || offHand) {
                NetworkHandler.instance().sendToServer(new MouseWheelPacket(verticalAmount > 0.0));
                return true;
            }
        }
        return false;
    }

    public boolean shouldAddParticles(class_5819 r) {
        return switch ((class_4066)class_310.method_1551().field_1690.method_42475().method_41753()) {
            default -> throw new IncompatibleClassChangeError();
            case class_4066.field_18197 -> true;
            case class_4066.field_18198 -> r.method_43056();
            case class_4066.field_18199 -> false;
        };
    }

    @Override
    public class_239 getCurrentMouseOver() {
        return class_310.method_1551().field_1765;
    }

    @Override
    public void spawnEffect(EffectType effect, class_1937 level, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Vibrant: {
                    this.spawnVibrant(level, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(level, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(level, posX, posY, posZ);
                    return;
                }
            }
        }
    }

    private void spawnVibrant(class_1937 level, double x, double y, double z) {
        if (AppEngClient.instance().shouldAddParticles(level.method_8409())) {
            double d0 = (double)(level.method_8409().method_43057() - 0.5f) * 0.26;
            double d1 = (double)(level.method_8409().method_43057() - 0.5f) * 0.26;
            double d2 = (double)(level.method_8409().method_43057() - 0.5f) * 0.26;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleTypes.VIBRANT, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
        }
    }

    private void spawnEnergy(class_1937 level, double posX, double posY, double posZ) {
        class_5819 random = level.method_8409();
        float x = (float)((double)(Math.abs(random.method_43054()) % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Math.abs(random.method_43054()) % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Math.abs(random.method_43054()) % 100) * 0.01 - 0.5) * 0.7f;
        class_310.method_1551().field_1713.method_3056((class_2394)EnergyParticleData.FOR_BLOCK, posX + (double)x, posY + (double)y, posZ + (double)z, (double)(-x) * 0.1, (double)(-y) * 0.1, (double)(-z) * 0.1);
    }

    private void spawnLightning(class_1937 level, double posX, double posY, double posZ) {
        class_310.method_1551().field_1713.method_3056((class_2394)ParticleTypes.LIGHTNING, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
    }

    private void updateCableRenderMode(class_310 mc) {
        CableRenderMode currentMode = this.getCableRenderMode();
        if (currentMode == this.prevCableRenderMode) {
            return;
        }
        this.prevCableRenderMode = currentMode;
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        int viewDistance = (int)Math.ceil(mc.field_1769.method_34812());
        class_1923.method_19280((class_1923)mc.field_1724.method_31476(), (int)viewDistance).forEach(chunkPos -> {
            class_2818 chunk = mc.field_1687.method_2935().method_21730(chunkPos.field_9181, chunkPos.field_9180);
            if (chunk != null) {
                for (int i = 0; i < chunk.method_32890(); ++i) {
                    class_2826 section = chunk.method_38259(i);
                    if (!section.method_19523(state -> state.method_27852((class_2248)AEBlocks.CABLE_BUS.block()))) continue;
                    mc.field_1769.method_8571(chunkPos.field_9181, chunk.method_31604(i), chunkPos.field_9180);
                }
            }
        });
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return CableRenderMode.STANDARD;
        }
        return this.getCableRenderModeForPlayer((class_1657)mc.field_1724);
    }

    @Override
    protected void initNetworkHandler() {
        new ClientNetworkHandler();
    }

    private class_1799 onPickBlock(class_1657 player, class_239 hitResult) {
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            class_2680 blockState = player.method_37908().method_8320(blockPos);
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof ICustomPickBlock) {
                ICustomPickBlock customPickBlock = (ICustomPickBlock)class_22482;
                return customPickBlock.getPickBlock(blockState, hitResult, (class_1922)player.method_37908(), blockPos, player);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public void openGuideAtPreviousPage(class_2960 initialPage) {
        try {
            GuideScreen screen = GuideScreen.openAtPreviousPage(this.guide, PageAnchor.page(initialPage), GlobalInMemoryHistory.INSTANCE);
            AppEngClient.openGuideScreen(screen);
        }
        catch (Exception e) {
            LOGGER.error("Failed to open guide.", (Throwable)e);
        }
    }

    @Override
    public void openGuideAtAnchor(PageAnchor anchor) {
        try {
            GuideScreen screen = GuideScreen.openNew(this.guide, anchor, GlobalInMemoryHistory.INSTANCE);
            AppEngClient.openGuideScreen(screen);
        }
        catch (Exception e) {
            LOGGER.error("Failed to open guide at {}.", (Object)anchor, (Object)e);
        }
    }

    private static void openGuideScreen(GuideScreen screen) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1755 != null) {
            screen.setReturnToOnClose(minecraft.field_1755);
        }
        minecraft.method_1507((class_437)screen);
    }

    public Guide getGuide() {
        return this.guide;
    }
}

