/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.core.AEConfig;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class CraftingJobStatusPacket
extends BasePacket {
    private UUID jobId;
    private AEKey what;
    private long requestedAmount;
    private long remainingAmount;
    private Status status;

    public CraftingJobStatusPacket(class_2540 stream) {
        this.jobId = stream.method_10790();
        this.status = (Status)stream.method_10818(Status.class);
        this.what = AEKey.readKey(stream);
        this.requestedAmount = stream.readLong();
        this.remainingAmount = stream.readLong();
    }

    public CraftingJobStatusPacket(UUID jobId, AEKey what, long requestedAmount, long remainingAmount, Status status) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10797(jobId);
        data.method_10817((Enum)status);
        AEKey.writeKey(data, what);
        data.writeLong(requestedAmount);
        data.writeLong(remainingAmount);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(class_1657 player) {
        if (this.status == Status.STARTED && AEConfig.instance().isPinAutoCraftedItems()) {
            PinnedKeys.pinKey(this.what, PinnedKeys.PinReason.CRAFTING);
        }
        PendingCraftingJobs.jobStatus(this.jobId, this.what, this.requestedAmount, this.remainingAmount, this.status);
    }

    public static enum Status {
        STARTED,
        CANCELLED,
        FINISHED;

    }
}

