/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.client.gui.me.patternaccess.PatternAccessTermScreen;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class PatternAccessTerminalPacket
extends BasePacket {
    private boolean fullUpdate;
    private long inventoryId;
    private int inventorySize;
    private long sortBy;
    private PatternContainerGroup group;
    private Int2ObjectMap<class_1799> slots;

    public PatternAccessTerminalPacket(class_2540 stream) {
        this.inventoryId = stream.method_10792();
        this.fullUpdate = stream.readBoolean();
        if (this.fullUpdate) {
            this.inventorySize = stream.method_10816();
            this.sortBy = stream.method_10792();
            this.group = PatternContainerGroup.readFromPacket(stream);
        }
        int slotsCount = stream.method_10816();
        this.slots = new Int2ObjectArrayMap(slotsCount);
        for (int i = 0; i < slotsCount; ++i) {
            int slot = stream.method_10816();
            class_1799 item = stream.method_10819();
            this.slots.put(slot, (Object)item);
        }
    }

    private PatternAccessTerminalPacket(boolean fullUpdate, long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<class_1799> slots) {
        class_2540 data = new class_2540(Unpooled.buffer((int)2048));
        data.writeInt(this.getPacketID());
        data.method_10791(inventoryId);
        data.writeBoolean(fullUpdate);
        if (fullUpdate) {
            data.method_10804(inventorySize);
            data.method_10791(sortBy);
            group.writeToPacket(data);
        }
        data.method_10804(slots.size());
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            data.method_10804(entry.getIntKey());
            data.method_10793((class_1799)entry.getValue());
        }
        this.configureWrite(data);
    }

    public static PatternAccessTerminalPacket fullUpdate(long inventoryId, int inventorySize, long sortBy, PatternContainerGroup group, Int2ObjectMap<class_1799> slots) {
        return new PatternAccessTerminalPacket(true, inventoryId, inventorySize, sortBy, group, slots);
    }

    public static PatternAccessTerminalPacket incrementalUpdate(long inventoryId, Int2ObjectMap<class_1799> slots) {
        return new PatternAccessTerminalPacket(false, inventoryId, 0, 0L, null, slots);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(class_1657 player) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof PatternAccessTermScreen) {
            PatternAccessTermScreen patternAccessTerminal = (PatternAccessTermScreen)class_4372;
            if (this.fullUpdate) {
                patternAccessTerminal.postFullUpdate(this.inventoryId, this.sortBy, this.group, this.inventorySize, this.slots);
            } else {
                patternAccessTerminal.postIncrementalUpdate(this.inventoryId, this.slots);
            }
        }
    }
}

