/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.locator;

import appeng.api.util.DimensionalBlockPos;
import appeng.menu.locator.BlockEntityLocator;
import appeng.menu.locator.MenuItemLocator;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.PartLocator;
import appeng.parts.AEBasePart;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public final class MenuLocators {
    private static final Map<String, Registration<?>> REGISTRY = new HashMap();

    public static synchronized <T extends MenuLocator> void register(Class<T> locatorClass, BiConsumer<T, class_2540> packetWriter, Function<class_2540, T> packetReader) {
        String classKey = locatorClass.getName();
        if (REGISTRY.containsKey(classKey)) {
            throw new IllegalStateException("MenuLocator type " + classKey + " is already registered.");
        }
        REGISTRY.put(classKey, new Registration<T>(locatorClass, packetWriter, packetReader));
    }

    private static synchronized Registration<?> getRegistration(String classKey) {
        Registration<?> registration = REGISTRY.get(classKey);
        if (registration == null) {
            throw new IllegalArgumentException("Unregistered menu locator class: " + classKey);
        }
        return registration;
    }

    public static <T extends MenuLocator> void writeToPacket(class_2540 buf, T locator) {
        String classKey = locator.getClass().getName();
        Registration<?> registration = MenuLocators.getRegistration(classKey);
        buf.method_10814(classKey);
        registration.writeToPacket.accept(locator, buf);
    }

    public static MenuLocator readFromPacket(class_2540 buf) {
        String classKey = buf.method_19772();
        Registration<?> registration = MenuLocators.getRegistration(classKey);
        return (MenuLocator)registration.readFromPacket.apply(buf);
    }

    public static MenuLocator forBlockEntity(class_2586 te) {
        if (te.method_10997() == null) {
            throw new IllegalArgumentException("Cannot open a block entity that is not in a level");
        }
        return new BlockEntityLocator(te.method_11016());
    }

    public static MenuLocator forPart(AEBasePart part) {
        DimensionalBlockPos pos = part.getHost().getLocation();
        return new PartLocator(pos.getPos(), part.getSide());
    }

    public static MenuLocator forItemUseContext(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            throw new IllegalArgumentException("Cannot open a menu without a player");
        }
        int slot = MenuLocators.getPlayerInventorySlotFromHand(player, context.method_20287());
        return new MenuItemLocator(slot, context.method_8037());
    }

    public static MenuLocator forHand(class_1657 player, class_1268 hand) {
        int slot = MenuLocators.getPlayerInventorySlotFromHand(player, hand);
        return MenuLocators.forInventorySlot(slot);
    }

    public static MenuLocator forInventorySlot(int inventorySlot) {
        return new MenuItemLocator(inventorySlot, null);
    }

    private static int getPlayerInventorySlotFromHand(class_1657 player, class_1268 hand) {
        class_1799 is = player.method_5998(hand);
        if (is.method_7960()) {
            throw new IllegalArgumentException("Cannot open an item-inventory with empty hands");
        }
        int invSize = player.method_31548().method_5439();
        for (int i = 0; i < invSize; ++i) {
            if (player.method_31548().method_5438(i) != is) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find item held in hand " + hand + " in player inventory");
    }

    static {
        MenuLocators.register(BlockEntityLocator.class, BlockEntityLocator::writeToPacket, BlockEntityLocator::readFromPacket);
        MenuLocators.register(PartLocator.class, PartLocator::writeToPacket, PartLocator::readFromPacket);
        MenuLocators.register(MenuItemLocator.class, MenuItemLocator::writeToPacket, MenuItemLocator::readFromPacket);
    }

    private record Registration<T extends MenuLocator>(Class<T> locatorClass, BiConsumer<T, class_2540> writeToPacket, Function<class_2540, T> readFromPacket) {
    }
}

