/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport.mdastpostprocess;

import appeng.client.guidebook.document.LytSize;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.scene.LytGuidebookScene;
import appeng.client.guidebook.scene.export.SceneExporter;
import appeng.libs.mdast.MdAstVisitor;
import appeng.libs.mdast.mdx.model.MdxJsxAttribute;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import appeng.siteexport.CacheBusting;
import appeng.siteexport.ResourceExporter;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SceneExportVisitor
implements MdAstVisitor {
    private static final int[] BLOCKIMAGE_SCALES = new int[]{2, 4, 8};
    private static final int GAMESCENE_PLACEHOLDER_SCALE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(SceneExportVisitor.class);
    private final ResourceExporter exporter;
    private final Multimap<MdAstNode, LytNode> nodeMapping;
    private int index;

    public SceneExportVisitor(ResourceExporter exporter, Multimap<MdAstNode, LytNode> nodeMapping) {
        this.exporter = exporter;
        this.nodeMapping = nodeMapping;
    }

    @Override
    public MdAstVisitor.Result beforeNode(MdAstNode node) {
        if (!(node instanceof MdxJsxElementFields)) {
            return MdAstVisitor.Result.CONTINUE;
        }
        MdxJsxElementFields elFields = (MdxJsxElementFields)((Object)node);
        String tagName = elFields.name();
        boolean isBlockImage = "BlockImage".equals(tagName);
        boolean isGameScene = "GameScene".equals(tagName);
        if (isBlockImage || isGameScene) {
            try {
                this.handleScene(node, elFields, tagName, isBlockImage, isGameScene);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return MdAstVisitor.Result.CONTINUE;
    }

    private void handleScene(MdAstNode node, MdxJsxElementFields elFields, String tagName, boolean isBlockImage, boolean isGameScene) throws IOException {
        List<LytGuidebookScene> scenes = this.nodeMapping.get((Object)node).stream().map(lytNode -> {
            LytGuidebookScene lytScene;
            return lytNode instanceof LytGuidebookScene ? (lytScene = (LytGuidebookScene)lytNode) : null;
        }).filter(Objects::nonNull).toList();
        if (scenes.isEmpty()) {
            LOG.warn("Found no layout scenes associated with element {} @ {}:{}", new Object[]{tagName, this.exporter.getCurrentPageId(), node.position()});
        } else {
            Object relativePath;
            if (scenes.size() > 1) {
                LOG.warn("Found multiple layout scenes associated with element {} @ {}:{}", new Object[]{tagName, this.exporter.getCurrentPageId(), node.position()});
            }
            LytGuidebookScene scene = scenes.get(0);
            String exportNamePrefix = isBlockImage ? "blockimage" : "scene";
            String exportName = exportNamePrefix + ++this.index;
            if (isGameScene) {
                relativePath = this.exportScene(scene, exportName);
                elFields.addAttribute("src", (String)relativePath);
            }
            if (isBlockImage) {
                if (scene.getScene() != null && SceneExporter.isAnimated(scene.getScene())) {
                    elFields.setName("GameScene");
                    elFields.attributes().clear();
                    elFields.addAttribute("background", "transparent");
                    relativePath = this.exportScene(scene, exportName);
                    elFields.addAttribute("src", (String)relativePath);
                    this.addPlaceholder(elFields, scene, exportName);
                } else {
                    for (Object scale : (Object)BLOCKIMAGE_SCALES) {
                        Path imagePath = this.exporter.getPageSpecificPathForWriting(exportName + "@" + (int)scale + ".png");
                        byte[] imageContent = scene.exportAsPng((float)scale, true);
                        if (imageContent == null) continue;
                        imagePath = CacheBusting.writeAsset(imagePath, imageContent);
                        String relativeImagePath = this.exporter.getPathRelativeFromOutputFolder(imagePath);
                        elFields.attributes().add(new MdxJsxAttribute("src@" + (int)scale, relativeImagePath));
                    }
                }
            } else if (isGameScene) {
                this.addPlaceholder(elFields, scene, exportName);
            }
            LytSize preferredSize = scene.getPreferredSize();
            if (!elFields.hasAttribute("width")) {
                elFields.addAttribute("width", preferredSize.width());
            }
            if (!elFields.hasAttribute("height")) {
                elFields.addAttribute("height", preferredSize.height());
            }
        }
    }

    private void addPlaceholder(MdxJsxElementFields elFields, LytGuidebookScene scene, String exportName) throws IOException {
        Path imagePath = this.exporter.getPageSpecificPathForWriting(exportName + ".png");
        byte[] imageContent = scene.exportAsPng(2.0f, true);
        if (imageContent != null) {
            imagePath = CacheBusting.writeAsset(imagePath, imageContent);
            String relativeImagePath = this.exporter.getPathRelativeFromOutputFolder(imagePath);
            elFields.attributes().add(new MdxJsxAttribute("placeholder", relativeImagePath));
        }
    }

    private String exportScene(LytGuidebookScene scene, String baseName) throws IOException {
        Path scenePath = this.exporter.getPageSpecificPathForWriting(baseName + ".scene.gz");
        SceneExporter exporter = new SceneExporter(this.exporter);
        byte[] sceneContent = exporter.export(scene.getScene());
        scenePath = CacheBusting.writeAsset(scenePath, sceneContent);
        return this.exporter.getPathRelativeFromOutputFolder(scenePath);
    }
}

