/*
 * Decompiled with CFR 0.152.
 */
package safro.archon.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;
import safro.archon.api.Element;
import safro.archon.api.spell.Spell;
import safro.archon.api.spell.SpellAttributable;
import safro.archon.enchantment.ArcaneEnchantment;
import safro.archon.registry.SpellRegistry;
import safro.archon.util.ArchonUtil;

public class SpellWeaponItem
extends class_1829
implements SpellAttributable {
    private final Element type;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public SpellWeaponItem(class_1832 toolMaterial, Element element, int power, double critDmg, double critChance, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.type = element;
        float damage = (float)attackDamage + toolMaterial.method_8028();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)damage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)attackSpeed, class_1322.class_1323.field_6328));
        this.addPower(builder, element, power);
        if (critDmg > 0.0) {
            this.addCritDamage(builder, critDmg);
        }
        if (critChance > 0.0) {
            this.addCritChance(builder, critChance);
        }
        this.attributeModifiers = builder.build();
    }

    @Override
    public Element getElement() {
        return this.type;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            if (this.getSpells(player).isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"text.archon.invalid_spell").method_27692(class_124.field_1061), true);
                return class_1271.method_22430((Object)stack);
            }
            Spell current = this.getCurrentSpell(stack, player);
            if (player.method_5715()) {
                this.cycleSpells(stack, player);
                player.method_7353((class_2561)class_2561.method_43471((String)this.getCurrentSpell(stack, player).getTranslationKey()).method_27692(class_124.field_1060), true);
                return class_1271.method_22427((Object)stack);
            }
            if (current != null && !current.isBlockCasted() && current.canCast(world, player, stack)) {
                current.cast(world, player, SpellPower.getSpellPower((SpellSchool)this.getElement().getSchool(), (class_1309)player), stack);
                ArcaneEnchantment.applyArcane(player, stack, current.getManaCost());
                if (current.getCastSound() != null) {
                    world.method_8396(null, player.method_24515(), current.getCastSound(), class_3419.field_15248, 0.9f, 1.0f);
                }
                return class_1271.method_22427((Object)stack);
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1657 player = context.method_8036();
        Spell current = this.getCurrentSpell(stack, player);
        if (!context.method_8045().method_8608() && player != null) {
            class_3218 world = (class_3218)context.method_8045();
            if (current != null && current.isBlockCasted() && ArchonUtil.canRemoveMana(player, current.getManaCost()) && current.castOnBlock(world, context.method_8037(), player, stack) == class_1269.field_5812) {
                ArcaneEnchantment.applyArcane(player, stack, current.getManaCost());
                if (current.getCastSound() != null) {
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), current.getCastSound(), class_3419.field_15248, 0.9f, 1.0f);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    @Nullable
    public Spell getCurrentSpell(class_1799 stack, class_1657 player) {
        if (stack.method_7911("archon").method_10545("CurrentSpell")) {
            String name = stack.method_7911("archon").method_10558("CurrentSpell");
            return (Spell)SpellRegistry.REGISTRY.method_10223(new class_2960(name));
        }
        if (this.getSpells(player).isEmpty()) {
            return null;
        }
        Spell spell = this.getSpells(player).get(0);
        stack.method_7911("archon").method_10582("CurrentSpell", SpellRegistry.REGISTRY.method_10221((Object)spell).toString());
        return spell;
    }

    public void cycleSpells(class_1799 stack, class_1657 player) {
        if (this.getSpells(player).size() > 1) {
            List<Spell> spells = ArchonUtil.getSpells(player);
            do {
                Collections.rotate(spells, 1);
                stack.method_7911("archon").method_10582("CurrentSpell", SpellRegistry.REGISTRY.method_10221((Object)spells.get(0)).toString());
            } while (this.getCurrentSpell(stack, player).getElement() != this.getElement());
        }
    }

    public ArrayList<Spell> getSpells(class_1657 player) {
        ArrayList<Spell> list = new ArrayList<Spell>();
        for (Spell spell : ArchonUtil.getSpells(player)) {
            if (spell.getElement() != this.getElement()) continue;
            list.add(spell);
        }
        return list;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7911("archon").method_10545("CurrentSpell")) {
            String name = stack.method_7911("archon").method_10558("CurrentSpell");
            Spell spell = (Spell)SpellRegistry.REGISTRY.method_10223(new class_2960(name));
            tooltip.add((class_2561)class_2561.method_43469((String)"text.archon.current_spell", (Object[])new Object[]{class_2561.method_43471((String)spell.getTranslationKey()).getString()}).method_27692(class_124.field_1080));
            tooltip.add(ArchonUtil.createManaText(spell.getManaCost(), false));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.archon.none").method_27692(class_124.field_1080));
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

