/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.platform;

import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.SwimData;
import artifacts.fabric.client.CosmeticsHelper;
import artifacts.fabric.registry.ModComponents;
import artifacts.fabric.trinket.TrinketsHelper;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformHelper;
import dev.emi.stepheightentityattribute.StepHeightEntityAttributeMain;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public boolean isEquippedBy(@Nullable class_1309 entity, Predicate<class_1799> predicate) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(component -> component.isEquipped(predicate)).orElse(false);
    }

    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, class_1792 item) {
        return TrinketsHelper.findAllEquippedBy(entity).filter(stack -> stack.method_7909() == item);
    }

    @Override
    public boolean tryEquipInFirstSlot(class_1309 entity, class_1799 item) {
        if (TrinketsApi.getTrinketComponent((class_1309)entity).isPresent()) {
            TrinketComponent component = (TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)entity).get();
            for (Map map : component.getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    if (!TrinketSlot.canInsert((class_1799)item, (SlotReference)new SlotReference(inventory, 0), (class_1309)entity) || !inventory.method_5438(0).method_7960()) continue;
                    inventory.method_5447(0, item);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public class_1320 getStepHeightAttribute() {
        return StepHeightEntityAttributeMain.STEP_HEIGHT;
    }

    @Override
    public boolean isCorrectTierForDrops(class_1832 tier, class_2680 state) {
        int i = tier.method_8024();
        if (state.method_26164(class_3481.field_33717)) {
            return i >= 3;
        }
        if (state.method_26164(class_3481.field_33718)) {
            return i >= 2;
        }
        if (state.method_26164(class_3481.field_33719)) {
            return i >= 1;
        }
        return true;
    }

    @Override
    @Nullable
    public SwimData getSwimData(class_1309 player) {
        return (SwimData)ModComponents.SWIM_DATA.getNullable((Object)player);
    }

    @Override
    public boolean isEyeInWater(class_1657 player) {
        return player.method_5777(class_3486.field_15517);
    }

    @Override
    public boolean isVisibleOnHand(class_1309 entity, class_1268 hand, WearableArtifactItem item) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).stream().flatMap(component -> component.getAllEquipped().stream()).filter(tuple -> ((SlotReference)tuple.method_15442()).inventory().getSlotType().getGroup().equals(hand == class_1268.field_5808 ? "hand" : "offhand")).map(class_3545::method_15441).filter(stack -> stack.method_31574((class_1792)item)).filter(stack -> !CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)).anyMatch(tuple -> true);
    }

    @Override
    public boolean areBootsHidden(class_1309 entity) {
        return false;
    }

    @Override
    public void registerArtifactRenderer(WearableArtifactItem item, Supplier<ArtifactRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new ArtifactTrinketRenderer(rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(class_1792 item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((class_1792)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactTrinketRenderer) {
            ArtifactTrinketRenderer artifactTrinketRenderer = (ArtifactTrinketRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    private record ArtifactTrinketRenderer(ArtifactRenderer renderer) implements TrinketRenderer
    {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)) {
                return;
            }
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.render(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

