/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.init.ConfigInit;
import net.dehydration.init.EffectInit;
import net.dehydration.item.LeatherFlask;
import net.dehydration.misc.ThirstTooltipData;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class DehydrationOverlay
extends BaseOverlay {
    private int blinkTime = 0;
    private final int[] qualityColor = new int[]{-13194241, -10839632, -3938534, -8467969};

    private void draw(class_332 guiGraphics, int left, int top, int right, int bottom, boolean highlight, int thirstColor, int foodLevel, float thirstQuench, int quality, float exhaustion, float alpha, boolean flip) {
        int boundColor = Utils.mixColor(-16777216, thirstColor, 0.5);
        if (highlight) {
            boundColor = Utils.mixColor(-1, thirstColor, 0.08);
        }
        this.drawBound(guiGraphics, left, top, right, bottom, boundColor);
        this.drawEmptyFill(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, AsteorBar.config.foodEmptyColor());
        int innerWidth = right - left - 2;
        int foodWidth = (int)((float)(innerWidth * foodLevel) / 20.0f);
        this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, foodWidth, thirstColor, flip);
        if (thirstQuench > 0.0f) {
            int quenchWidth = (int)((float)innerWidth * (thirstQuench / 20.0f));
            quenchWidth = Math.min(quenchWidth, innerWidth - foodWidth);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (flip) {
                this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1 - foodWidth, bottom - 1, quenchWidth, this.qualityColor[Math.max(0, Math.min(3, quality))], true);
            } else {
                this.drawFillFlip(guiGraphics, left + 1 + foodWidth, top + 1, right - 1, bottom - 1, quenchWidth, this.qualityColor[Math.max(0, Math.min(3, quality))], false);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int exhaustionWidth = (int)((float)innerWidth * (Math.min(4.0f, exhaustion) / 4.0f));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!AsteorBar.compatibility.dehydration || !AsteorBar.config.hookDehydration()) {
            return;
        }
        class_746 player = gui.mc().field_1724;
        if (player == null) {
            return;
        }
        ThirstManager thirstManager = ((ThirstManagerAccess)player).getThirstManager();
        if (!thirstManager.hasThirst()) {
            return;
        }
        int thirst = thirstManager.getThirstLevel();
        float dehydration = thirstManager.dehydration;
        int thirstColor = -15028249;
        if (player.method_6059(EffectInit.THIRST)) {
            thirstColor = -3938534;
        }
        if (player.method_32312() > 0) {
            thirstColor = -8467969;
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (thirstManager.dehydration >= 4.0f && gui.gui().method_1738() % (thirst * 3 + 1) == 0) {
                this.blinkTime = 2;
            }
            if (this.blinkTime > 0) {
                --this.blinkTime;
            }
        }
        int thirstQuench = 0;
        int quality = 0;
        float alpha = 1.0f;
        if (ConfigInit.CONFIG.thirst_preview && thirst < 20) {
            class_1799 itemStack = null;
            if (!player.method_6047().method_7960() && !player.method_6047().method_32347().isEmpty() && player.method_6047().method_32347().get() instanceof ThirstTooltipData) {
                itemStack = player.method_6047();
            } else if (player.method_6079().method_7960() && !player.method_6079().method_32347().isEmpty() && player.method_6079().method_32347().get() instanceof ThirstTooltipData) {
                itemStack = player.method_6079();
            }
            if (itemStack != null) {
                thirstQuench = ((ThirstTooltipData)itemStack.method_32347().get()).getThirstQuench();
                if (itemStack.method_7909() instanceof LeatherFlask) {
                    thirstQuench = ConfigInit.CONFIG.flask_thirst_quench;
                }
                quality = ((ThirstTooltipData)itemStack.method_32347().get()).getDrinkQuality();
                alpha = (float)Math.cos((double)(gui.gui().method_1738() % 40) / 40.0 * Math.PI * 2.0) * 0.5f + 0.5f;
            }
        }
        switch (Overlays.style) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int left = screenWidth / 2 + 10;
                int top = screenHeight - gui.rightHeight() + 4;
                gui.rightHeight(6);
                this.draw(guiGraphics, left, top, left + 81, top + 5, this.blinkTime > 0, thirstColor, thirst, thirstQuench, quality, dehydration, alpha, true);
                break;
            }
            case 3: {
                int top = Overlays.vertical;
                int left = Overlays.horizontal;
                this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, thirstQuench, quality, dehydration, alpha, false);
                Overlays.vertical += 6;
                break;
            }
            case 4: {
                int top = Overlays.vertical;
                int left = screenWidth - Overlays.length - Overlays.horizontal;
                this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, thirstQuench, quality, dehydration, alpha, true);
                Overlays.vertical += 6;
                break;
            }
            case 5: {
                int top = screenHeight - Overlays.vertical;
                int left = Overlays.horizontal;
                this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, thirstQuench, quality, dehydration, alpha, false);
                Overlays.vertical += 6;
                break;
            }
            case 6: {
                int top = screenHeight - Overlays.vertical;
                int left = screenWidth - Overlays.length - Overlays.horizontal;
                this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, this.blinkTime > 0, thirstColor, thirst, thirstQuench, quality, dehydration, alpha, true);
                Overlays.vertical += 6;
            }
        }
    }
}

