/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class ExperienceBarOverlay
extends BaseOverlay {
    private void draw(class_332 guiGraphics, int left, int top, int right, int bottom, float exp, String levelStr, boolean flip) {
        this.drawBound(guiGraphics, left, top, right, bottom, AsteorBar.config.experienceBoundColor());
        this.drawEmptyFill(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, AsteorBar.config.experienceEmptyColor());
        int innerWidth = right - left - 2;
        int expWidth = (int)((float)innerWidth * exp);
        if (expWidth > 0) {
            this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, expWidth, AsteorBar.config.experienceColor(), flip);
        }
        int textureWidth = Math.min(179, Math.max(0, (innerWidth + 5) / 10 - 1) * 10 + 9);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        this.drawTextureFillColor(guiGraphics, left + 1, top, innerWidth, 5, 10, 18, textureWidth, 5, AsteorBar.config.experienceColor());
        RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        if (AsteorBar.config.displayExperienceLevel()) {
            int x = (right + left) / 2;
            int y = top - 2;
            Overlays.addStringRender(x, y, 8453920, levelStr, 1, false, true, 0);
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        class_310 mc = gui.mc();
        class_746 player = mc.field_1724;
        if (player == null || player.method_45773() != null || gui.mc().field_1690.field_1842) {
            return;
        }
        if (mc.field_1761 == null || !mc.field_1761.method_2913()) {
            return;
        }
        if (AsteorBar.config.overwriteVanillaExperienceBar()) {
            String levelStr = String.valueOf(player.field_7520);
            switch (Overlays.style) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    int top = screenHeight - 29;
                    int left = screenWidth / 2 - 91;
                    this.draw(guiGraphics, left, top, left + 182, top + 5, player.field_7510, levelStr, false);
                    break;
                }
                case 3: {
                    int top = Overlays.vertical;
                    int left = Overlays.horizontal;
                    this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, player.field_7510, levelStr, false);
                    Overlays.vertical += 6;
                    break;
                }
                case 4: {
                    int top = Overlays.vertical;
                    int left = screenWidth - Overlays.length - Overlays.horizontal;
                    this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, player.field_7510, levelStr, true);
                    Overlays.vertical += 6;
                    break;
                }
                case 5: {
                    int top = screenHeight - Overlays.vertical;
                    int left = Overlays.horizontal;
                    this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, player.field_7510, levelStr, false);
                    Overlays.vertical += 6;
                    break;
                }
                case 6: {
                    int top = screenHeight - Overlays.vertical;
                    int left = screenWidth - Overlays.length - Overlays.horizontal;
                    this.draw(guiGraphics, left, top, left + Overlays.length, top + 5, player.field_7510, levelStr, true);
                    Overlays.vertical += 6;
                }
            }
        }
        if (AsteorBar.config.displayExperienceProgress()) {
            String need = String.valueOf(player.method_7349());
            String has = String.valueOf((int)(player.field_7510 * (float)player.method_7349()));
            int x = -1;
            int y = -1;
            int len = 0;
            boolean inside = false;
            int style = Overlays.style;
            if (!AsteorBar.config.overwriteVanillaExperienceBar()) {
                style = 1;
            }
            switch (style) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    x = screenWidth / 2;
                    y = screenHeight - 31;
                    len = 91;
                    break;
                }
                case 3: {
                    y = Overlays.vertical - 8;
                    len = Overlays.length / 2;
                    x = Overlays.horizontal + len;
                    inside = true;
                    break;
                }
                case 4: {
                    y = Overlays.vertical - 8;
                    len = Overlays.length / 2;
                    x = screenWidth - Overlays.horizontal - len;
                    inside = true;
                    break;
                }
                case 5: {
                    y = screenHeight - Overlays.vertical + 4;
                    len = Overlays.length / 2;
                    x = Overlays.horizontal + len;
                    inside = true;
                    break;
                }
                case 6: {
                    y = screenHeight - Overlays.vertical + 4;
                    len = Overlays.length / 2;
                    x = screenWidth - Overlays.horizontal - len;
                    inside = true;
                }
            }
            if (x >= 0 && y >= 0) {
                if (inside) {
                    Overlays.addStringRender(x - len + 2, y, 0xFFFFFF, has, 0, true);
                    Overlays.addStringRender(x + len - 2, y, 0xFFFFFF, need, 2, true);
                } else {
                    Overlays.addStringRender(x - len, y, 0xFFFFFF, has, 2, true);
                    Overlays.addStringRender(x + len, y, 0xFFFFFF, need, 0, true);
                }
            }
        }
    }
}

