/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.utils.PlatformAdapter;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class FoodLevelOverlay
extends BaseOverlay {
    private int foodBlinkTime = 0;
    private final int[] shift = new int[]{0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1};

    private void draw(class_332 guiGraphics, int left, int top, int right, int bottom, boolean highlight, int foodColor, int foodLevel, float saturation, float exhaustion, int foodIncrement, float saturationIncrement, int tick, boolean flip) {
        RenderSystem.enableBlend();
        int verticalShift = 0;
        if (foodLevel <= 4) {
            verticalShift = this.shift[tick / (foodLevel + 1) % this.shift.length];
            top += verticalShift;
            bottom += verticalShift;
        }
        int boundColor = highlight ? AsteorBar.config.foodBoundColorBlink() : AsteorBar.config.foodBoundColor();
        this.drawBound(guiGraphics, left, top, right, bottom, boundColor);
        this.drawEmptyFill(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, AsteorBar.config.foodEmptyColor());
        int innerWidth = right - left - 2;
        int foodWidth = (int)((double)innerWidth * (double)foodLevel / (double)AsteorBar.config.fullFoodLevelValue());
        this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, foodWidth, foodColor, flip);
        float alpha = (float)Math.cos((double)(tick % 40) / 40.0 * Math.PI * 2.0) * 0.5f + 0.5f;
        if (foodIncrement > 0 && foodLevel < AsteorBar.config.fullFoodLevelValue()) {
            int incrementWidth = foodLevel + foodIncrement >= AsteorBar.config.fullFoodLevelValue() ? innerWidth - foodWidth : (int)((double)innerWidth * (double)foodIncrement / (double)AsteorBar.config.fullFoodLevelValue());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.drawFillFlipConcat(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, foodWidth, incrementWidth, foodColor, flip);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (AsteorBar.config.displaySaturation()) {
            int saturationWidth = (int)((double)(right - left) * ((double)saturation / AsteorBar.config.fullSaturationValue()));
            this.drawBoundFlip(guiGraphics, left, top, right, bottom, saturationWidth, AsteorBar.config.saturationColor(), flip);
            if (foodIncrement > 0 && saturationIncrement > 0.0f && (double)saturation < AsteorBar.config.fullSaturationValue()) {
                int incrementWidth = (double)(saturation + saturationIncrement) >= AsteorBar.config.fullSaturationValue() ? right - left - saturationWidth : (int)((double)(right - left) * ((double)saturationIncrement / AsteorBar.config.fullSaturationValue()));
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                this.drawBoundFlipConcat(guiGraphics, left, top, right, bottom, saturationWidth, incrementWidth, AsteorBar.config.saturationColor(), flip);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int exhaustionWidth = (int)((double)innerWidth * (Math.min(AsteorBar.config.fullExhaustionValue(), (double)exhaustion) / AsteorBar.config.fullExhaustionValue()));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
        top -= verticalShift;
        if (AsteorBar.config.displayFoodText()) {
            String foodText = Utils.formatNumber(foodLevel) + "/" + Utils.formatNumber(AsteorBar.config.fullFoodLevelValue());
            Overlays.addStringRender((left + right) / 2, top - 2, 0xFFFFFF, foodText, 1, true);
        }
        RenderSystem.disableBlend();
    }

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        int right;
        int top;
        int left;
        PlatformAdapter.AppleSkinFoodValues foodValues;
        class_746 player = gui.mc().field_1724;
        if (player == null) {
            return;
        }
        class_1702 stats = player.method_7344();
        int level = stats.method_7586();
        float saturation = stats.method_7589();
        float exhaustion = stats.method_35219();
        int foodType = AsteorBar.config.foodColorNormal();
        if (player.method_6059(class_1294.field_5903)) {
            foodType = AsteorBar.config.foodColorHunger();
        }
        int foodIncrement = 0;
        float saturationIncrement = 0.0f;
        if (AsteorBar.compatibility.appleskin && (foodValues = AsteorBar.platformAdapter.getAppleSkinFoodValues((class_1657)player)) != null) {
            foodIncrement = foodValues.hungerIncrement();
            saturationIncrement = foodValues.saturationIncrement();
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (player.method_7344().method_7589() <= 0.0f && (long)gui.gui().method_1738() % ((long)Math.max(4, level) * 3L + 1L) == 0L) {
                this.foodBlinkTime = 2;
            }
            if (this.foodBlinkTime > 0) {
                --this.foodBlinkTime;
            }
        }
        boolean flip = false;
        switch (Overlays.style) {
            default: {
                return;
            }
            case 1: {
                left = screenWidth / 2 - 91;
                top = screenHeight - gui.rightHeight() + 4;
                right = left + 182;
                gui.rightHeight(12);
                break;
            }
            case 2: {
                left = screenWidth / 2 + 10;
                top = screenHeight - gui.rightHeight() + 4;
                right = left + 81;
                flip = true;
                gui.rightHeight(6);
                break;
            }
            case 3: {
                top = Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                Overlays.vertical += 6;
                break;
            }
            case 4: {
                top = Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
                break;
            }
            case 5: {
                top = screenHeight - Overlays.vertical;
                left = Overlays.horizontal;
                right = left + Overlays.length;
                Overlays.vertical += 6;
                break;
            }
            case 6: {
                top = screenHeight - Overlays.vertical;
                left = screenWidth - Overlays.length - Overlays.horizontal;
                right = left + Overlays.length;
                flip = true;
                Overlays.vertical += 6;
            }
        }
        this.draw(guiGraphics, left, top, right, top + 5, this.foodBlinkTime > 0, foodType, level, saturation, exhaustion, foodIncrement, saturationIncrement, gui.gui().method_1738(), flip);
    }
}

