/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import mod.azure.azurelibarmor.AzureLibException;
import mod.azure.azurelibarmor.cache.AzureLibCache;
import mod.azure.azurelibarmor.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.cache.object.GeoBone;
import mod.azure.azurelibarmor.constant.DataTickets;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animatable.model.CoreGeoModel;
import mod.azure.azurelibarmor.core.animation.AnimatableManager;
import mod.azure.azurelibarmor.core.animation.Animation;
import mod.azure.azurelibarmor.core.animation.AnimationProcessor;
import mod.azure.azurelibarmor.core.animation.AnimationState;
import mod.azure.azurelibarmor.core.molang.MolangParser;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.loading.object.BakedAnimations;
import mod.azure.azurelibarmor.util.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public abstract class GeoModel<T extends GeoAnimatable>
implements CoreGeoModel<T> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract class_2960 getModelResource(T var1);

    public abstract class_2960 getTextureResource(T var1);

    public abstract class_2960 getAnimationResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    public class_1921 getRenderType(T animatable, class_2960 texture) {
        return class_1921.method_23578((class_2960)texture);
    }

    @Override
    public final BakedGeoModel getBakedGeoModel(String location) {
        return this.getBakedModel(new class_2960(location));
    }

    public BakedGeoModel getBakedModel(class_2960 location) {
        BakedGeoModel model = AzureLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new AzureLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    @Override
    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable((GeoBone)this.getAnimationProcessor().getBone(name));
    }

    @Override
    public Animation getAnimation(T animatable, String name) {
        class_2960 location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = AzureLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            throw new AzureLibException(location, "Unable to find animation.");
        }
        return bakedAnimations.getAnimation(name);
    }

    @Override
    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @Override
    public final void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        boolean isReRender;
        class_310 mc = class_310.method_1551();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (animatable instanceof class_1309) {
                class_1309 livingEntity = (class_1309)animatable;
                d = livingEntity.field_6012;
            } else {
                d = RenderUtils.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)mc.method_1488());
        }
        double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!(isReRender || mc.method_1493() && !animatable.shouldPlayAnimsWhileGamePaused())) {
            if (animatable instanceof class_1309) {
                animatableManager.updatedAt(currentFrameTime);
            } else {
                animatableManager.updatedAt(currentFrameTime);
            }
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    @Override
    public void applyMolangQueries(T animatable, double animTime) {
        MolangParser parser = MolangParser.INSTANCE;
        class_310 mc = class_310.method_1551();
        parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
        parser.setMemoizedValue("query.actor_count", () -> ((class_638)mc.field_1687).method_18120());
        parser.setMemoizedValue("query.time_of_day", () -> (float)mc.field_1687.method_8532() / 24000.0f);
        parser.setMemoizedValue("query.moon_phase", () -> ((class_638)mc.field_1687).method_30273());
        if (animatable instanceof class_1297) {
            class_1297 entity = (class_1297)animatable;
            parser.setMemoizedValue("query.distance_from_camera", () -> mc.field_1773.method_19418().method_19326().method_1022(entity.method_19538()));
            parser.setMemoizedValue("query.is_on_ground", () -> RenderUtils.booleanToFloat(entity.method_24828()));
            parser.setMemoizedValue("query.is_in_water", () -> RenderUtils.booleanToFloat(entity.method_5799()));
            parser.setMemoizedValue("query.is_in_water_or_rain", () -> RenderUtils.booleanToFloat(entity.method_5637()));
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                parser.setMemoizedValue("query.health", () -> ((class_1309)livingEntity).method_6032());
                parser.setMemoizedValue("query.max_health", () -> ((class_1309)livingEntity).method_6063());
                parser.setMemoizedValue("query.is_on_fire", () -> RenderUtils.booleanToFloat(livingEntity.method_5809()));
                parser.setMemoizedValue("query.ground_speed", () -> {
                    class_243 velocity = livingEntity.method_18798();
                    return class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)));
                });
                parser.setMemoizedValue("query.yaw_speed", () -> livingEntity.method_5705((float)animTime - livingEntity.method_5705((float)animTime - 0.1f)));
            }
        }
    }
}

