/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelibarmor.animatable.GeoItem;
import mod.azure.azurelibarmor.cache.object.BakedGeoModel;
import mod.azure.azurelibarmor.cache.object.GeoBone;
import mod.azure.azurelibarmor.cache.texture.AnimatableTexture;
import mod.azure.azurelibarmor.constant.DataTickets;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animation.AnimationState;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.event.GeoRenderArmorEvent;
import mod.azure.azurelibarmor.model.GeoModel;
import mod.azure.azurelibarmor.platform.Services;
import mod.azure.azurelibarmor.renderer.GeoRenderer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayer;
import mod.azure.azurelibarmor.renderer.layer.GeoRenderLayersContainer;
import mod.azure.azurelibarmor.util.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoArmorRenderer<T extends class_1792>
extends class_572
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected class_572<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;
    protected GeoBone rightBoot = null;
    protected GeoBone leftBoot = null;
    protected class_1297 currentEntity = null;
    protected class_1799 currentStack = null;
    protected class_1304 currentSlot = null;

    public GeoArmorRenderer(GeoModel<T> model) {
        super(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
        this.model = model;
        this.field_3448 = false;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public class_1297 getCurrentEntity() {
        return this.currentEntity;
    }

    public class_1799 getCurrentStack() {
        return this.currentStack;
    }

    public class_1304 getCurrentSlot() {
        return this.currentSlot;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentStack) + (long)this.currentEntity.method_5628();
    }

    @Override
    public class_1921 getRenderType(T animatable, class_2960 texture, @Nullable class_4597 bufferSource, float partialTick) {
        return class_1921.method_25448((class_2960)texture);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Nullable
    public GeoBone getHeadBone() {
        return this.model.getBone("armorHead").orElse(null);
    }

    @Nullable
    public GeoBone getBodyBone() {
        return this.model.getBone("armorBody").orElse(null);
    }

    @Nullable
    public GeoBone getRightArmBone() {
        return this.model.getBone("armorRightArm").orElse(null);
    }

    @Nullable
    public GeoBone getLeftArmBone() {
        return this.model.getBone("armorLeftArm").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegBone() {
        return this.model.getBone("armorRightLeg").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegBone() {
        return this.model.getBone("armorLeftLeg").orElse(null);
    }

    @Nullable
    public GeoBone getRightBootBone() {
        return this.model.getBone("armorRightBoot").orElse(null);
    }

    @Nullable
    public GeoBone getLeftBootBone() {
        return this.model.getBone("armorLeftBoot").orElse(null);
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(this.animatable)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForBaby(poseStack, animatable, partialTick, isReRender);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!(this.currentEntity instanceof GeoAnimatable)) {
            this.applyBoneVisibilityBySlot(this.currentSlot);
        }
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        class_310 mc = class_310.method_1551();
        class_4597.class_4598 bufferSource = class_310.method_1551().field_1769.field_20951.method_23000();
        if (class_310.method_1551().field_1769.method_3270() && mc.method_27022(this.currentEntity)) {
            bufferSource = class_310.method_1551().field_1769.field_20951.method_23003();
        }
        float partialTick = mc.method_1488();
        class_1921 renderType = this.getRenderType(this.animatable, this.getTextureLocation((GeoAnimatable)this.animatable), (class_4597)bufferSource, partialTick);
        buffer = class_918.method_27952((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (boolean)this.currentStack.method_7958());
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, (class_4597)bufferSource, null, buffer, 0.0f, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoItem)animatable).getTick(this.currentEntity));
            animationState.setData(DataTickets.ITEMSTACK, this.currentStack);
            animationState.setData(DataTickets.ENTITY, this.currentEntity);
            animationState.setData(DataTickets.EQUIPMENT_SLOT, this.currentSlot);
            this.model.addAdditionalStateData((class_1792)animatable, instanceId, (BiConsumer<DataTicket<class_1792>, class_1792>)((BiConsumer<DataTicket, class_1792>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.method_22909();
    }

    @Override
    public void renderRecursively(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(this.currentEntity, 1.0f).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.currentEntity.method_19538().method_46409()));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public class_243 getRenderOffset(class_1297 entity, float f) {
        return class_243.field_1353;
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        this.lastModel = bakedModel;
        this.head = this.getHeadBone();
        this.body = this.getBodyBone();
        this.rightArm = this.getRightArmBone();
        this.leftArm = this.getLeftArmBone();
        this.rightLeg = this.getRightLegBone();
        this.leftLeg = this.getLeftLegBone();
        this.rightBoot = this.getRightBootBone();
        this.leftBoot = this.getLeftBootBone();
    }

    public void prepForRender(@Nullable class_1297 entity, class_1799 stack, @Nullable class_1304 slot, @Nullable class_572<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = stack.method_7909();
        this.currentSlot = slot;
    }

    protected void applyBaseModel(class_572<?> baseModel) {
        this.field_3448 = baseModel.field_3448;
        this.field_3400 = baseModel.field_3400;
        this.field_3449 = baseModel.field_3449;
        this.field_3395 = baseModel.field_3395;
        this.field_3399 = baseModel.field_3399;
    }

    protected void applyBoneVisibilityBySlot(class_1304 currentSlot) {
        this.method_2805(false);
        switch (currentSlot) {
            case field_6169: {
                this.setBoneVisible(this.head, true);
                break;
            }
            case field_6174: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                break;
            }
            case field_6172: {
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                break;
            }
            case field_6166: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(class_1304 currentSlot, class_630 currentPart, class_572<?> model) {
        this.method_2805(false);
        currentPart.field_3665 = true;
        GeoBone bone = null;
        if (currentPart == model.field_3394 || currentPart == model.field_3398) {
            bone = this.head;
        } else if (currentPart == model.field_3391) {
            bone = this.body;
        } else if (currentPart == model.field_27433) {
            bone = this.leftArm;
        } else if (currentPart == model.field_3401) {
            bone = this.rightArm;
        } else if (currentPart == model.field_3397) {
            bone = currentSlot == class_1304.field_6166 ? this.leftBoot : this.leftLeg;
        } else if (currentPart == model.field_3392) {
            GeoBone geoBone = bone = currentSlot == class_1304.field_6166 ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(class_572<?> baseModel) {
        if (this.head != null) {
            class_630 headPart = baseModel.field_3398;
            RenderUtils.matchModelPartRot(headPart, this.head);
            this.head.updatePosition(headPart.field_3657, -headPart.field_3656, headPart.field_3655);
        }
        if (this.body != null) {
            class_630 bodyPart = baseModel.field_3391;
            RenderUtils.matchModelPartRot(bodyPart, this.body);
            this.body.updatePosition(bodyPart.field_3657, -bodyPart.field_3656, bodyPart.field_3655);
        }
        if (this.rightArm != null) {
            class_630 rightArmPart = baseModel.field_3401;
            RenderUtils.matchModelPartRot(rightArmPart, this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_3657 + 5.0f, 2.0f - rightArmPart.field_3656, rightArmPart.field_3655);
        }
        if (this.leftArm != null) {
            class_630 leftArmPart = baseModel.field_27433;
            RenderUtils.matchModelPartRot(leftArmPart, this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_3657 - 5.0f, 2.0f - leftArmPart.field_3656, leftArmPart.field_3655);
        }
        if (this.rightLeg != null) {
            class_630 rightLegPart = baseModel.field_3392;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.field_3657 + 2.0f, 12.0f - rightLegPart.field_3656, rightLegPart.field_3655);
            }
        }
        if (this.leftLeg != null) {
            class_630 leftLegPart = baseModel.field_3397;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.field_3657 - 2.0f, 12.0f - leftLegPart.field_3656, leftLegPart.field_3655);
            }
        }
    }

    public void method_2805(boolean pVisible) {
        super.method_2805(pVisible);
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(class_4587 poseStack, T animatable, float partialTick, boolean isReRender) {
        if (!this.field_3448 || isReRender) {
            return;
        }
        if (this.currentSlot == class_1304.field_6169) {
            if (this.baseModel.field_20915) {
                float headScale = 1.5f / this.baseModel.field_20918;
                poseStack.method_22905(headScale, headScale, headScale);
            }
            poseStack.method_46416(0.0f, this.baseModel.field_20916 / 16.0f, this.baseModel.field_20917 / 16.0f);
        } else {
            float bodyScale = 1.0f / this.baseModel.field_20919;
            poseStack.method_22905(bodyScale, bodyScale, bodyScale);
            poseStack.method_46416(0.0f, this.baseModel.field_20920 / 16.0f, 0.0f);
        }
    }

    protected void setBoneVisible(@Nullable GeoBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        if (this.currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.getTextureLocation((GeoAnimatable)animatable), this.currentEntity.method_5628() + this.currentEntity.field_6012);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeoRenderArmorEvent.CompileRenderLayers.EVENT.handle(new GeoRenderArmorEvent.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        boolean event = GeoRenderArmorEvent.Pre.EVENT.handle(new GeoRenderArmorEvent.Pre(this, poseStack, model, bufferSource, partialTick, packedLight));
        return Services.PLATFORM.getPlatformName().equalsIgnoreCase("forge") ? !event : event;
    }

    @Override
    public void firePostRenderEvent(class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, float partialTick, int packedLight) {
        GeoRenderArmorEvent.Post.EVENT.handle(new GeoRenderArmorEvent.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

