/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.chunk.IDistanceManager;
import com.betterchunkloading.chunk.IPlayerDataPlayer;
import com.betterchunkloading.chunk.PlayerChunkData;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_3204;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_4076;
import net.minecraft.class_6609;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3204.class})
public abstract class DistanceManagerMixin
implements IDistanceManager {
    @Shadow
    @Final
    private class_3204.class_3948 field_17455;
    @Shadow
    @Final
    private class_6609 field_34886;
    @Unique
    final Long2IntMap playerCountPerChunk = new Long2IntOpenHashMap();

    @Shadow
    protected abstract int method_38633();

    @Override
    public Long2IntMap getPlayerCountPerChunk() {
        return this.playerCountPerChunk;
    }

    @Inject(method={"addPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V")}, cancellable=true)
    private void onAddPlayerToChunkSection(class_4076 chunkSection, class_3222 player, CallbackInfo ci) {
        if (!(player instanceof IPlayerDataPlayer)) {
            return;
        }
        ci.cancel();
        PlayerChunkData data = ((IPlayerDataPlayer)player).betterchunkloading$getPlayerChunkData();
        data.onChunkChanged(player);
        class_1923 newTicketPos = data.getSlowAvgPos();
        if (newTicketPos != null && newTicketPos.equals((Object)data.getLazyLoadingLastTicketPos())) {
            return;
        }
        if (newTicketPos == null) {
            newTicketPos = player.method_31476();
        }
        this.playerCountPerChunk.put(newTicketPos.method_8324(), this.playerCountPerChunk.getOrDefault(newTicketPos.method_8324(), 0) + 1);
        this.field_17455.method_14027(newTicketPos.method_8324(), 0, true);
        this.field_34886.method_38638(class_3230.field_14033, newTicketPos, this.method_38633(), (Object)newTicketPos);
        data.setLazyLoadingLastTicketPos(newTicketPos);
    }

    @Inject(method={"removePlayer"}, at={@At(value="HEAD")})
    private void onRemovePlayerFromChunkSection(class_4076 chunkSection, class_3222 player, CallbackInfo ci) {
        if (!(player instanceof IPlayerDataPlayer)) {
            return;
        }
        PlayerChunkData data = ((IPlayerDataPlayer)player).betterchunkloading$getPlayerChunkData();
        data.onChunkChanged(player);
        class_1923 avgTicketPos = data.getSlowAvgPos();
        if (avgTicketPos != null && avgTicketPos.equals((Object)data.getLazyLoadingLastTicketPos()) && !player.method_31481()) {
            return;
        }
        this.betterchunkloading$removePlayer(data);
    }

    @Inject(method={"removePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V")}, cancellable=true)
    private void betterchunkloading$skipRemovePlayer(class_4076 p_140829_, class_3222 p_140830_, CallbackInfo ci) {
        ci.cancel();
    }

    @Unique
    private void betterchunkloading$removePlayer(PlayerChunkData data) {
        class_1923 toUnload = data.getLazyLoadingLastTicketPos();
        if (toUnload != null) {
            long posKey = toUnload.method_8324();
            if (!this.playerCountPerChunk.containsKey(posKey)) {
                BetterChunkLoading.LOGGER.warn("missing player in chunk");
            }
            if (this.playerCountPerChunk.get(posKey) <= 1) {
                this.playerCountPerChunk.remove(posKey);
                this.field_17455.method_14027(posKey, Integer.MAX_VALUE, false);
                this.field_34886.method_38642(class_3230.field_14033, toUnload, this.method_38633(), (Object)toUnload);
            } else {
                this.playerCountPerChunk.put(toUnload.method_8324(), this.playerCountPerChunk.getOrDefault(toUnload.method_8324(), 0) - 1);
            }
            data.setLazyLoadingLastTicketPos(null);
        }
    }
}

