/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.betterstats.client.gui.stats.panel.StatsTabPanel;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.PlayerBadgeStatsTab;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class PBSummaryPanel
extends BSComponentPanel {
    private final IStatsProvider statsProvider;
    protected int maxEntries = 10;

    public PBSummaryPanel(int x, int y, int width, int height, IStatsProvider statsProvider) {
        super(x, y, width, height);
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.setScrollPadding(5);
        this.setScrollFlags(4);
    }

    public final IStatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public final void setMaxEntries(int maxEntries) {
        this.maxEntries = Math.abs(maxEntries);
    }

    protected final void init() {
        List<SUPlayerBadgeStat> stats = SUPlayerBadgeStat.getPlayerBadgeStats(this.statsProvider, s -> !s.isEmpty()).stream().sorted(Comparator.comparingInt(entry -> entry.value).reversed()).limit(this.maxEntries).collect(Collectors.toList());
        PlayerBadgeStatsTab.initStats((TPanelElement)this, stats, w -> w.setSize(20, 20));
        if (this.getChildren().size() == 0) {
            Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect((TPanelElement)this);
            TLabelElement lbl = new TLabelElement(n1.x, this.getY() + this.getHeight() / 2 - n1.height / 2, n1.width, n1.height, StatsTabPanel.TXT_NO_STATS_YET);
            lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
            this.addChild((TElement)lbl, false);
        }
    }
}

