/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.api.util.BSUtils;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class SUItemStat
extends SUStat<class_1792> {
    protected final class_1792 item;
    @Nullable
    protected final class_2248 block;
    protected final boolean isEmpty;
    public final int mined;
    public final int crafted;
    public final int used;
    public final int broken;
    public final int pickedUp;
    public final int dropped;

    public SUItemStat(IStatsProvider statsProvider, class_1792 item) {
        super(statsProvider, class_7923.field_41178.method_10221((Object)Objects.requireNonNull(item)), SUItemStat.getItemStatText(item));
        this.item = item;
        this.block = class_2248.method_9503((class_1792)item);
        this.mined = this.block == null ? 0 : statsProvider.getStatValue(class_3468.field_15427, this.block);
        this.crafted = statsProvider.getStatValue(class_3468.field_15370, item);
        this.used = statsProvider.getStatValue(class_3468.field_15372, item);
        this.broken = statsProvider.getStatValue(class_3468.field_15383, item);
        this.pickedUp = statsProvider.getStatValue(class_3468.field_15392, item);
        this.dropped = statsProvider.getStatValue(class_3468.field_15405, item);
        this.isEmpty = this.mined == 0 && this.crafted == 0 && this.used == 0 && this.broken == 0 && this.pickedUp == 0 && this.dropped == 0;
    }

    public final class_1792 getItem() {
        return this.item;
    }

    @Nullable
    public final class_2248 getBlock() {
        return this.block;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static class_2561 getItemStatText(class_1792 item) {
        return TextUtils.fTranslatable((String)item.method_7876(), (Object[])new Object[0]);
    }

    public static List<SUItemStat> getItemStats(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        ArrayList<SUItemStat> result = new ArrayList<SUItemStat>();
        for (class_1792 itemReg : class_7923.field_41178) {
            SUItemStat itemStat = new SUItemStat(statsProvider, itemReg);
            if (filter != null && !filter.test(itemStat)) continue;
            result.add(itemStat);
        }
        return result;
    }

    public static Map<class_1761, List<SUItemStat>> getItemStatsByItemGroups(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        LinkedHashMap<class_1761, List<SUItemStat>> result = new LinkedHashMap<class_1761, List<SUItemStat>>();
        result.put(null, new ArrayList());
        for (SUItemStat itemStat : SUItemStat.getItemStats(statsProvider, filter)) {
            class_1761 itemRegGroup = BSUtils.getItemGroup(itemStat.item);
            if (!result.containsKey(itemRegGroup)) {
                result.put(itemRegGroup, new ArrayList());
            }
            result.get(itemRegGroup).add(itemStat);
        }
        if (((List)result.get(null)).size() == 0) {
            result.remove(null);
        }
        return result;
    }

    public static Map<String, List<SUItemStat>> getItemStatsByModGroups(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        LinkedHashMap<String, List<SUItemStat>> result = new LinkedHashMap<String, List<SUItemStat>>();
        String mcModId = new class_2960("air").method_12836();
        result.put(mcModId, new ArrayList());
        for (SUItemStat itemStat : SUItemStat.getItemStats(statsProvider, filter)) {
            String itemModId = itemStat.getStatID().method_12836();
            if (!result.containsKey(itemModId)) {
                result.put(itemModId, Lists.newArrayList());
            }
            List<SUItemStat> resultList = result.get(itemModId);
            resultList.add(itemStat);
        }
        if (((List)result.get(mcModId)).size() == 0) {
            result.remove(mcModId);
        }
        return result;
    }

    public static Map<class_2561, List<SUItemStat>> getItemStatsByItemGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        Map<class_1761, List<SUItemStat>> stats = SUItemStat.getItemStatsByItemGroups(statsProvider, filter);
        LinkedHashMap<class_2561, List<SUItemStat>> mapped = new LinkedHashMap<class_2561, List<SUItemStat>>();
        for (Map.Entry<class_1761, List<SUItemStat>> entry : stats.entrySet()) {
            class_5250 txt = entry.getKey() != null ? entry.getKey().method_7737() : TextUtils.literal((String)"*");
            mapped.put((class_2561)txt, entry.getValue());
        }
        return mapped;
    }

    public static Map<class_2561, List<SUItemStat>> getItemStatsByModGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUItemStat> filter) {
        Map<String, List<SUItemStat>> stats = SUItemStat.getItemStatsByModGroups(statsProvider, filter);
        LinkedHashMap<class_2561, List<SUItemStat>> mapped = new LinkedHashMap<class_2561, List<SUItemStat>>();
        for (Map.Entry<String, List<SUItemStat>> entry : stats.entrySet()) {
            class_5250 txt = entry.getKey() != null ? TextUtils.literal((String)TUtils.getModName((String)entry.getKey())) : TextUtils.literal((String)"*");
            mapped.put((class_2561)txt, entry.getValue());
        }
        return mapped;
    }
}

