/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.stats.panel.StatsSummaryPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.ItemStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortItemsBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui.screen.hud.entry.StatsHudItemEntry;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
@ApiStatus.Internal
public class ItemStatsTab
extends BSStatsTab<SUItemStat> {
    @Override
    @Virtual
    public class_2561 getName() {
        return TextUtils.translatable((String)"stat.itemsButton", (Object[])new Object[0]);
    }

    @Override
    @Virtual
    public void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        IStatsProvider stats = initContext.getStatsProvider();
        StatFilterSettings filters = initContext.getFilterSettings();
        Predicate<SUItemStat> predicate = this.getPredicate(initContext.getFilterSettings());
        FilterGroupBy filter_group = (FilterGroupBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortItemsBy filter_sort = (FilterSortItemsBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SORT_ITEMS, (Object)FilterSortItemsBy.DEFAULT));
        Map<Object, Object> statGroups = null;
        switch (filter_group) {
            case ALL: {
                statGroups = new LinkedHashMap();
                statGroups.put(TextUtils.literal((String)"*"), SUItemStat.getItemStats(stats, predicate));
                break;
            }
            case MOD: {
                statGroups = SUItemStat.getItemStatsByModGroupsB(stats, predicate);
                break;
            }
            default: {
                statGroups = this.getStatsDefault(stats, predicate);
            }
        }
        filter_sort.sortItemStats(statGroups);
        for (Map.Entry<Object, Object> statGroup : statGroups.entrySet()) {
            class_2561 group = (class_2561)statGroup.getKey();
            StatsTabUtils.initGroupLabel(panel, (class_2561)(group != null ? group : TextUtils.literal((String)"*")));
            ItemStatsTab.initStats(panel, (Collection)statGroup.getValue(), widget -> this.processWidget((ItemStatWidget)((Object)widget)));
        }
        StatsSummaryPanel summary = ItemStatsTab.initStatsSummary(panel);
        if (summary != null) {
            summary.summarizeItemStats(statGroups.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    @Override
    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortItemsByFilter(initContext);
    }

    @Virtual
    protected Map<class_2561, List<SUItemStat>> getStatsDefault(IStatsProvider stats, @Nullable Predicate<SUItemStat> predicate) {
        return SUItemStat.getItemStatsByItemGroupsB(stats, predicate);
    }

    @Virtual
    protected void processWidget(ItemStatWidget widget) {
        widget.eContextMenu.register((__, cMenu) -> {
            cMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.client.gui.screen.hud.betterstatshudscreen.pin_stat", (Object[])new Object[0]), ___ -> {
                BetterStatsHudScreen hud = BetterStatsHudScreen.getInstance();
                hud.setParentScreen(BetterStatsClient.MC_CLIENT.field_1755);
                hud.addEntry(new StatsHudItemEntry((SUItemStat)widget.getStat()));
                BetterStatsClient.MC_CLIENT.method_1507(hud.getAsScreen());
            });
            cMenu.addButton((class_2561)TextUtils.translatable((String)"mco.selectServer.close", (Object[])new Object[0]), ___ -> {});
        });
    }

    protected static void initStats(TPanelElement panel, Collection<SUItemStat> stats, Consumer<ItemStatWidget> processWidget) {
        int wmp = panel.getWidth() - panel.getScrollPadding() * 2;
        int nextX = panel.getScrollPadding();
        int nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY();
        for (SUItemStat stat : stats) {
            ItemStatWidget statElement = new ItemStatWidget(nextX, nextY, stat);
            panel.addChild((TElement)statElement, true);
            if (processWidget != null) {
                processWidget.accept(statElement);
            }
            if ((nextX += 24) + 21 < wmp) continue;
            nextX = panel.getScrollPadding();
            nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY() + 3;
        }
    }
}

