/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.api.block;

import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.block.entity.UsesAltarPower;
import moriyashiine.bewitchment.api.registry.AltarMapEntry;
import moriyashiine.bewitchment.common.BWConfig;
import moriyashiine.bewitchment.common.block.entity.WitchAltarBlockEntity;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.registry.BWTags;
import moriyashiine.bewitchment.common.world.BWWorldState;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class WitchAltarBlock
extends class_2383
implements class_2343,
class_3737 {
    private static final class_265 SHAPE = class_259.method_17786((class_265)WitchAltarBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (class_265[])new class_265[]{WitchAltarBlock.method_9541((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), WitchAltarBlock.method_9541((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), WitchAltarBlock.method_9541((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), WitchAltarBlock.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private final class_2248 unformed;
    private final boolean formed;

    public WitchAltarBlock(class_4970.class_2251 settings, class_2248 unformed, boolean formed) {
        super(settings);
        this.unformed = unformed;
        this.formed = formed;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.formed ? new WitchAltarBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world0, class_2680 state0, class_2591<T> type) {
        return (world, pos, state, blockEntity) -> WitchAltarBlockEntity.tick(world, pos, state, (WitchAltarBlockEntity)blockEntity);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean client = world.field_9236;
        class_1799 stack = player.method_5998(hand);
        if (!this.formed) {
            AltarMapEntry entry = BewitchmentAPI.ALTAR_MAP_ENTRIES.stream().filter(e -> e.unformed() == this && e.carpet() == stack.method_7909()).findFirst().orElse(null);
            if (entry != null) {
                if (!client) {
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    class_2350 facing = (class_2350)world.method_8320(pos).method_11654((class_2769)field_11177);
                    world.method_22352(pos, false);
                    world.method_8501(pos, (class_2680)entry.formed().method_9605(new class_1750(player, hand, stack, hit)).method_11657((class_2769)field_11177, (Comparable)facing));
                }
                return class_1269.method_29236((boolean)client);
            }
        } else {
            WitchAltarBlockEntity blockEntity = (WitchAltarBlockEntity)world.method_8321(pos);
            if (!client) {
                if (!stack.method_7960()) {
                    boolean sword = stack.method_31573(BWTags.SWORDS);
                    boolean pentacle = stack.method_31573(BWTags.PENTACLES);
                    boolean wand = stack.method_31573(BWTags.WANDS);
                    if (sword || pentacle || wand) {
                        int slot = sword ? 0 : (pentacle ? 1 : 2);
                        class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)(pos.method_10264() + 1), (double)((double)pos.method_10260() + 0.5), (class_1799)blockEntity.method_5434(slot, 1));
                        blockEntity.method_5447(slot, stack.method_7971(1));
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(WitchAltarBlock.calculateLuminance(blockEntity))), 11);
                        world.method_8455(pos, (class_2248)this);
                        blockEntity.markedForScan = true;
                        blockEntity.method_5431();
                        blockEntity.sync();
                    }
                } else if (player.method_5715()) {
                    class_1264.method_5451((class_1937)world, (class_2338)pos.method_10069(0, 1, 0), (class_1263)blockEntity);
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(0)), 11);
                    world.method_8455(pos, (class_2248)this);
                    blockEntity.markedForScan = true;
                    blockEntity.method_5431();
                    blockEntity.sync();
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)(blockEntity.power + " / " + blockEntity.maxPower + " (" + blockEntity.gain + "x)")), true);
                }
            }
            return class_1269.method_29236((boolean)client);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        if (this.unformed != null) {
            return new class_1799((class_1935)this.unformed);
        }
        return super.method_9574(world, pos, state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)super.method_9605(ctx).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910))).method_11657((class_2769)field_11177, (Comparable)ctx.method_8042());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9498(class_2680 state) {
        return this.formed;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        if (this.formed) {
            WitchAltarBlockEntity blockEntity = (WitchAltarBlockEntity)world.method_8321(pos);
            int items = 0;
            for (int i = 0; i < blockEntity.method_5439(); ++i) {
                if (blockEntity.method_5438(i).method_7960()) continue;
                ++items;
            }
            return items;
        }
        return 0;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (this.formed) {
            if (!world.field_9236 && state.method_26204() != oldState.method_26204()) {
                BWWorldState worldState = BWWorldState.get(world);
                worldState.potentialCandelabras.add(pos.method_10063());
                worldState.method_80();
            }
            for (class_2338 foundPos : BWUtil.getBlockPoses(pos, BWConfig.altarDistributionRadius)) {
                class_2586 class_25862;
                if (!world.method_8621().method_11952(foundPos) || !((class_25862 = world.method_8321(foundPos)) instanceof UsesAltarPower)) continue;
                UsesAltarPower usesAltarPower = (UsesAltarPower)class_25862;
                usesAltarPower.setAltarPos(WitchAltarBlock.getClosestAltarPos(world, foundPos));
                ((class_2586)usesAltarPower).method_5431();
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!world.field_9236 && state.method_26204() != newState.method_26204()) {
            BWWorldState worldState = BWWorldState.get(world);
            for (int i = worldState.potentialCandelabras.size() - 1; i >= 0; --i) {
                if (worldState.potentialCandelabras.get(i).longValue() != pos.method_10063()) continue;
                worldState.potentialCandelabras.remove(i);
                worldState.method_80();
            }
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof class_1263) {
                class_1263 inventory = (class_1263)class_25862;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)inventory);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
        if (!world.field_9236 && state.method_26204() != newState.method_26204()) {
            for (class_2338 foundPos : BWUtil.getBlockPoses(pos, BWConfig.altarDistributionRadius)) {
                class_2586 class_25863 = world.method_8321(foundPos);
                if (!(class_25863 instanceof UsesAltarPower)) continue;
                UsesAltarPower usesAltarPower = (UsesAltarPower)class_25863;
                usesAltarPower.setAltarPos(WitchAltarBlock.getClosestAltarPos(world, foundPos));
                ((class_2586)usesAltarPower).method_5431();
            }
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12508, field_11177, class_2741.field_12538});
    }

    @Nullable
    public static class_2338 getClosestAltarPos(class_1937 world, class_2338 pos) {
        return BWUtil.getClosestBlockPos(pos, BWConfig.altarDistributionRadius, currentPos -> world.method_8321(currentPos) instanceof WitchAltarBlockEntity);
    }

    private static int calculateLuminance(WitchAltarBlockEntity blockEntity) {
        class_1747 blockItem;
        int luminance = 0;
        class_1792 sword = blockEntity.method_5438(0).method_7909();
        class_1792 pentacle = blockEntity.method_5438(1).method_7909();
        class_1792 wand = blockEntity.method_5438(2).method_7909();
        if (sword instanceof class_1747) {
            blockItem = (class_1747)sword;
            luminance = Math.max(luminance, blockItem.method_7711().method_9564().method_26213());
        }
        if (pentacle instanceof class_1747) {
            blockItem = (class_1747)pentacle;
            luminance = Math.max(luminance, blockItem.method_7711().method_9564().method_26213());
        }
        if (wand instanceof class_1747) {
            blockItem = (class_1747)wand;
            luminance = Math.max(luminance, blockItem.method_7711().method_9564().method_26213());
        }
        return luminance;
    }
}

