/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common.block.entity;

import java.util.HashMap;
import java.util.Map;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.component.CursesComponent;
import moriyashiine.bewitchment.common.registry.BWBlockEntityTypes;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWCurses;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWTags;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2372;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4849;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WitchAltarBlockEntity
extends class_2586
implements class_1263 {
    private int loadingTimer = 20;
    private final Map<class_2248, Integer> checked = new HashMap<class_2248, Integer>();
    private final class_2338.class_2339 checking = new class_2338.class_2339();
    private int counter = 0;
    public int power = 0;
    public int maxPower = 0;
    public int gain = 1;
    public boolean markedForScan = false;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);

    public WitchAltarBlockEntity(class_2338 pos, class_2680 state) {
        super(BWBlockEntityTypes.WITCH_ALTAR, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory.clear();
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.power = nbt.method_10550("Power");
        this.maxPower = nbt.method_10550("MaxPower");
        this.gain = nbt.method_10550("Gain");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("Power", this.power);
        nbt.method_10569("MaxPower", this.maxPower);
        nbt.method_10569("Gain", this.gain);
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, WitchAltarBlockEntity blockEntity) {
        if (world != null && !world.field_9236) {
            if (blockEntity.loadingTimer > 0) {
                --blockEntity.loadingTimer;
                if (blockEntity.loadingTimer == 0) {
                    blockEntity.markedForScan = true;
                }
            } else {
                if (world.method_8510() % 20L == 0L) {
                    blockEntity.method_5431();
                }
                if (blockEntity.markedForScan) {
                    blockEntity.counter = 0;
                    blockEntity.checked.clear();
                    blockEntity.scan(Short.MAX_VALUE);
                    blockEntity.markedForScan = false;
                }
                blockEntity.scan(40);
                if (world.method_8510() % 20L == 0L) {
                    blockEntity.power = world.method_8320(pos.method_10084()).method_26204() == BWObjects.BLESSED_STONE ? Integer.MAX_VALUE : Math.min(blockEntity.power + blockEntity.gain, blockEntity.maxPower);
                    PlayerLookup.around((class_3218)((class_3218)world), (class_243)class_243.method_24954((class_2382)pos), (double)24.0).forEach(player -> {
                        if (player.method_36608() && !player.method_7337() && !((CursesComponent)BWComponents.CURSES_COMPONENT.get(player)).hasCurse(BWCurses.APATHY) && BewitchmentAPI.fillMagic((class_1657)player, 5, true) && blockEntity.drain(10, true)) {
                            BewitchmentAPI.fillMagic((class_1657)player, 5, false);
                            blockEntity.drain(10, false);
                        }
                    });
                }
            }
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) < 16.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public boolean drain(int amount, boolean simulate) {
        if (this.power - amount >= 0) {
            if (!simulate) {
                this.power -= amount;
            }
            return true;
        }
        return false;
    }

    private void scan(int times) {
        if (this.field_11863 != null) {
            for (int i = 0; i < times; ++i) {
                ++this.counter;
                this.counter %= Short.MAX_VALUE;
                int x = this.counter & 0x1F;
                int y = this.counter >> 5 & 0x1F;
                int z = this.counter >> 10 & 0x1F;
                class_2680 checkedState = this.field_11863.method_8320((class_2338)this.checking.method_10103(this.field_11867.method_10263() + x - 15, this.field_11867.method_10264() + y - 15, this.field_11867.method_10260() + z - 15));
                class_2248 checkedBlock = checkedState.method_26204();
                if (!(!WitchAltarBlockEntity.givesAltarPower(checkedState) || checkedState.method_26164(class_3481.field_15475) && class_7923.field_41175.method_10221((Object)checkedBlock).method_12832().contains("stripped"))) {
                    this.checked.put(checkedBlock, Math.min(this.checked.getOrDefault(checkedBlock, 0) + 1, 256));
                }
                if (this.counter != 32766) continue;
                this.gain = WitchAltarBlockEntity.getPentacleValue(this.method_5438(1));
                this.maxPower = 0;
                float varietyMultiplier = 1.0f;
                for (class_2248 block : this.checked.keySet()) {
                    if (this.checked.get(block) > 3) {
                        varietyMultiplier *= 1.1f;
                    }
                    this.maxPower += this.checked.get(block).intValue();
                }
                this.maxPower = (int)((float)this.maxPower * Math.min(varietyMultiplier, 4.0f) / 10.0f * WitchAltarBlockEntity.getSwordValue(this.method_5438(0)) + (float)WitchAltarBlockEntity.getWandValue(this.method_5438(2)));
                this.power = Math.min(this.power, this.maxPower);
                this.checked.clear();
            }
        }
    }

    private static boolean givesAltarPower(class_2680 state) {
        if (state.method_26204() instanceof class_2261 || state.method_26204() instanceof class_2381 || state.method_26204() instanceof class_2256 && !(state.method_26204() instanceof class_2372) && !(state.method_26204() instanceof class_4849)) {
            return true;
        }
        return state.method_26164(BWTags.GIVES_ALTAR_POWER);
    }

    private static float getSwordValue(class_1799 stack) {
        return stack.method_31573(BWTags.WEAK_SWORDS) ? 1.1f : (stack.method_31573(BWTags.AVERAGE_SWORDS) ? 1.2f : (stack.method_31573(BWTags.STRONG_SWORDS) ? 1.3f : 1.0f));
    }

    private static int getPentacleValue(class_1799 stack) {
        return stack.method_31573(BWTags.WEAK_PENTACLES) ? 2 : (stack.method_31573(BWTags.AVERAGE_PENTACLES) ? 3 : (stack.method_31573(BWTags.STRONG_PENTACLES) ? 5 : 1));
    }

    private static int getWandValue(class_1799 stack) {
        return stack.method_31573(BWTags.WEAK_WANDS) ? 40 : (stack.method_31573(BWTags.AVERAGE_WANDS) ? 80 : (stack.method_31573(BWTags.STRONG_WANDS) ? 120 : 0));
    }
}

