/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.config.BlurConfig;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import java.util.Objects;
import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class Blur
implements ClientModInitializer {
    public static final String MODID = "blur";
    public static final class_310 client = class_310.method_1551();
    public static long start;
    public static String prevScreen;
    public static boolean screenHasBackground;
    private static final ManagedShaderEffect blur;
    private static final Uniform1f blurProgress;
    private static boolean doFade;

    public void onInitializeClient() {
        BlurConfig.init((String)MODID, BlurConfig.class);
        ShaderEffectRenderCallback.EVENT.register(deltaTick -> {
            if (start > 0L) {
                blurProgress.set(Blur.getProgress(Blur.client.field_1755 != null));
                blur.render(deltaTick);
            }
        });
    }

    public static void onScreenChange(class_437 newGui) {
        if (Blur.client.field_1687 != null) {
            boolean excluded;
            boolean bl = excluded = newGui == null || BlurConfig.blurExclusions.stream().anyMatch(exclusion -> newGui.getClass().getName().contains((CharSequence)exclusion));
            if (!excluded) {
                screenHasBackground = false;
                if (BlurConfig.showScreenTitle) {
                    System.out.println(newGui.getClass().getName());
                }
                blur.setUniformValue("Radius", (float)BlurConfig.radius);
                if (doFade) {
                    start = System.currentTimeMillis();
                    doFade = false;
                }
                prevScreen = newGui.getClass().getName();
            } else if (newGui == null && BlurConfig.fadeOutTimeMillis > 0 && !Objects.equals(prevScreen, "")) {
                blur.setUniformValue("Radius", (float)BlurConfig.radius);
                start = System.currentTimeMillis();
                doFade = true;
            } else {
                screenHasBackground = false;
                start = -1L;
                doFade = true;
                prevScreen = "";
            }
        }
    }

    private static float getProgress(boolean fadeIn) {
        float x;
        if (fadeIn) {
            x = Math.min((float)(System.currentTimeMillis() - start) / (float)BlurConfig.fadeTimeMillis, 1.0f);
            if (BlurConfig.ease) {
                x *= 2.0f - x;
            }
        } else {
            x = Math.max(1.0f + (float)(start - System.currentTimeMillis()) / (float)BlurConfig.fadeOutTimeMillis, 0.0f);
            if (BlurConfig.ease) {
                x *= 2.0f - x;
            }
            if (x <= 0.0f) {
                start = 0L;
                screenHasBackground = false;
            }
        }
        return x;
    }

    public static int getBackgroundColor(boolean second, boolean fadeIn) {
        int a = second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha;
        Color col = MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        int r = col.getRGB() >> 16 & 0xFF;
        int b = col.getRGB() >> 8 & 0xFF;
        int g = col.getRGB() & 0xFF;
        float prog = Blur.getProgress(fadeIn);
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }

    static {
        blur = ShaderEffectManager.getInstance().manage(new class_2960(MODID, "shaders/post/fade_in_blur.json"), shader -> shader.setUniformValue("Radius", (float)BlurConfig.radius));
        blurProgress = blur.findUniform1f("Progress");
        doFade = false;
    }
}

