/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import tschipp.carryon.Constants;
import tschipp.carryon.utils.StringHelper;

public class ListHandler {
    private static Set<String> FORBIDDEN_TILES = new HashSet<String>();
    private static Set<String> FORBIDDEN_ENTITIES = new HashSet<String>();
    private static Set<String> ALLOWED_ENTITIES = new HashSet<String>();
    private static Set<String> ALLOWED_TILES = new HashSet<String>();
    private static Set<String> FORBIDDEN_STACKING = new HashSet<String>();
    private static Set<String> ALLOWED_STACKING = new HashSet<String>();
    private static List<class_6862<class_2248>> FORBIDDEN_TILES_TAGS = new ArrayList<class_6862<class_2248>>();
    private static List<class_6862<class_1299<?>>> FORBIDDEN_ENTITIES_TAGS = new ArrayList();
    private static List<class_6862<class_1299<?>>> ALLOWED_ENTITIES_TAGS = new ArrayList();
    private static List<class_6862<class_2248>> ALLOWED_TILES_TAGS = new ArrayList<class_6862<class_2248>>();
    private static List<class_6862<class_1299<?>>> FORBIDDEN_STACKING_TAGS = new ArrayList();
    private static List<class_6862<class_1299<?>>> ALLOWED_STACKING_TAGS = new ArrayList();
    private static Set<class_2769<?>> PROPERTY_EXCEPTION_CLASSES = new HashSet();

    public static boolean isPermitted(class_2248 block) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistBlocks) {
            return ListHandler.doCheck(block, ALLOWED_TILES, ALLOWED_TILES_TAGS);
        }
        return !ListHandler.doCheck(block, FORBIDDEN_TILES, FORBIDDEN_TILES_TAGS);
    }

    public static boolean isPermitted(class_1297 entity) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistEntities) {
            return ListHandler.doCheck(entity, ALLOWED_ENTITIES, ALLOWED_ENTITIES_TAGS);
        }
        return !ListHandler.doCheck(entity, FORBIDDEN_ENTITIES, FORBIDDEN_ENTITIES_TAGS);
    }

    public static boolean isStackingPermitted(class_1297 entity) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistStacking) {
            return ListHandler.doCheck(entity, ALLOWED_STACKING, ALLOWED_STACKING_TAGS);
        }
        return !ListHandler.doCheck(entity, FORBIDDEN_STACKING, FORBIDDEN_STACKING_TAGS);
    }

    public static boolean isPropertyException(class_2769<?> prop) {
        return PROPERTY_EXCEPTION_CLASSES.contains(prop);
    }

    private static boolean doCheck(class_2248 block, Set<String> regular, List<class_6862<class_2248>> tags) {
        String name = class_7923.field_41175.method_10221((Object)block).toString();
        if (regular.contains(name)) {
            return true;
        }
        for (class_6862<class_2248> tag : tags) {
            if (!block.method_9564().method_26164(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean doCheck(class_1297 entity, Set<String> regular, List<class_6862<class_1299<?>>> tags) {
        String name = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        if (regular.contains(name)) {
            return true;
        }
        for (class_6862<class_1299<?>> tag : tags) {
            if (!entity.method_5864().method_20210(tag)) continue;
            return true;
        }
        return false;
    }

    public static void initConfigLists() {
        FORBIDDEN_ENTITIES.clear();
        FORBIDDEN_ENTITIES_TAGS.clear();
        FORBIDDEN_STACKING.clear();
        FORBIDDEN_STACKING_TAGS.clear();
        FORBIDDEN_TILES.clear();
        FORBIDDEN_TILES_TAGS.clear();
        ALLOWED_ENTITIES.clear();
        ALLOWED_ENTITIES_TAGS.clear();
        ALLOWED_STACKING.clear();
        ALLOWED_STACKING_TAGS.clear();
        ALLOWED_TILES.clear();
        ALLOWED_TILES_TAGS.clear();
        PROPERTY_EXCEPTION_CLASSES.clear();
        Map blocktags = class_7923.field_41175.method_40273().collect(Collectors.toMap(t -> t.comp_327(), t -> t));
        Map entitytags = class_7923.field_41177.method_40273().collect(Collectors.toMap(t -> t.comp_327(), t -> t));
        ArrayList<String> forbidden = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenTiles));
        forbidden.add("#carryon:block_blacklist");
        ListHandler.addWithWildcards(forbidden, FORBIDDEN_TILES, class_7923.field_41175, blocktags, FORBIDDEN_TILES_TAGS);
        ArrayList<String> forbiddenEntity = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenEntities));
        forbiddenEntity.add("#carryon:entity_blacklist");
        ListHandler.addWithWildcards(forbiddenEntity, FORBIDDEN_ENTITIES, class_7923.field_41177, entitytags, FORBIDDEN_ENTITIES_TAGS);
        ArrayList<String> allowedEntities = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedEntities));
        allowedEntities.add("#carryon:entity_whitelist");
        ListHandler.addWithWildcards(allowedEntities, ALLOWED_ENTITIES, class_7923.field_41177, entitytags, ALLOWED_ENTITIES_TAGS);
        ArrayList<String> allowedBlocks = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedBlocks));
        allowedBlocks.add("#carryon:block_whitelist");
        ListHandler.addWithWildcards(allowedBlocks, ALLOWED_TILES, class_7923.field_41175, blocktags, ALLOWED_TILES_TAGS);
        ArrayList<String> forbiddenStacking = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenStacking));
        forbiddenStacking.add("#carryon:stacking_blacklist");
        ListHandler.addWithWildcards(forbiddenStacking, FORBIDDEN_STACKING, class_7923.field_41177, entitytags, FORBIDDEN_STACKING_TAGS);
        ArrayList<String> allowedStacking = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedStacking));
        allowedStacking.add("#carryon:stacking_whitelist");
        ListHandler.addWithWildcards(allowedStacking, ALLOWED_STACKING, class_7923.field_41177, entitytags, ALLOWED_STACKING_TAGS);
        for (String propString : Constants.COMMON_CONFIG.settings.placementStateExceptions) {
            if (!propString.contains("[") || !propString.contains("]")) continue;
            String name = propString.substring(0, propString.indexOf("["));
            String props = propString.substring(propString.indexOf("[") + 1, propString.indexOf("]"));
            class_2248 blk = (class_2248)class_7923.field_41175.method_10223(new class_2960(name));
            for (String propName : props.split(",")) {
                for (class_2769 prop : blk.method_9564().method_28501()) {
                    if (!prop.method_11899().equals(propName)) continue;
                    PROPERTY_EXCEPTION_CLASSES.add(prop);
                }
            }
        }
    }

    private static <T> void addTag(String tag, Map<class_2960, class_6862<T>> tagMap, List<class_6862<T>> tags) {
        String sub = tag.substring(1);
        class_6862<T> t = tagMap.get(new class_2960(sub));
        if (t != null) {
            tags.add(t);
        }
    }

    private static <T> void addWithWildcards(List<String> entries, Set<String> toAddTo, class_2378<T> registry, Map<class_2960, class_6862<T>> tags, List<class_6862<T>> toAddTags) {
        class_2960[] keys = registry.method_10235().toArray(new class_2960[0]);
        for (int i = 0; i < entries.size(); ++i) {
            String curr = entries.get(i);
            if (!curr.startsWith("#")) {
                if (curr.contains("*")) {
                    String[] filter = curr.replace("*", ",").split(",");
                    for (class_2960 key : keys) {
                        if (!ListHandler.containsAll(key.toString(), filter)) continue;
                        toAddTo.add(key.toString());
                    }
                    continue;
                }
                toAddTo.add(curr);
                continue;
            }
            ListHandler.addTag(curr, tags, toAddTags);
        }
    }

    public static boolean containsAll(String str, String ... strings) {
        return StringHelper.matchesWildcards(str, strings);
    }

    public static void addForbiddenTiles(String toAdd) {
        FORBIDDEN_TILES.add(toAdd);
    }

    public static void addForbiddenEntities(String toAdd) {
        FORBIDDEN_ENTITIES.add(toAdd);
    }

    public static void addForbiddenStacking(String toAdd) {
        FORBIDDEN_STACKING.add(toAdd);
    }

    public static void addAllowedTiles(String toAdd) {
        ALLOWED_TILES.add(toAdd);
    }

    public static void addAllowedEntities(String toAdd) {
        ALLOWED_ENTITIES.add(toAdd);
    }

    public static void addAllowedStacking(String toAdd) {
        ALLOWED_ENTITIES.add(toAdd);
    }
}

