/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.Holiday;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TurtleBlockEntityRenderer
implements class_827<TurtleBlockEntity> {
    private static final class_1091 NORMAL_TURTLE_MODEL = new class_1091("computercraft", "turtle_normal", "inventory");
    private static final class_1091 ADVANCED_TURTLE_MODEL = new class_1091("computercraft", "turtle_advanced", "inventory");
    private static final class_2960 COLOUR_TURTLE_MODEL = new class_2960("computercraft", "block/turtle_colour");
    private static final class_2960 ELF_OVERLAY_MODEL = new class_2960("computercraft", "block/turtle_elf_overlay");
    private final class_824 renderer;
    private final class_327 font;

    public TurtleBlockEntityRenderer(class_5614.class_5615 context) {
        this.renderer = context.method_32139();
        this.font = context.method_32143();
    }

    public static class_2960 getTurtleModel(ComputerFamily family, boolean coloured) {
        return switch (family) {
            default -> {
                if (coloured) {
                    yield COLOUR_TURTLE_MODEL;
                }
                yield NORMAL_TURTLE_MODEL;
            }
            case ComputerFamily.ADVANCED -> coloured ? COLOUR_TURTLE_MODEL : ADVANCED_TURTLE_MODEL;
        };
    }

    @Nullable
    public static class_2960 getTurtleOverlayModel(@Nullable class_2960 overlay, boolean christmas) {
        if (overlay != null) {
            return overlay;
        }
        if (christmas) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    public void render(TurtleBlockEntity turtle, float partialTicks, class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight) {
        int[] nArray;
        transform.method_22903();
        class_243 offset = turtle.getRenderOffset(partialTicks);
        transform.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        String label = turtle.getLabel();
        class_239 hit = this.renderer.field_4350;
        if (label != null && hit.method_17783() == class_239.class_240.field_1332 && turtle.method_11016().equals((Object)((class_3965)hit).method_17777())) {
            class_310 mc = class_310.method_1551();
            class_327 font = this.font;
            transform.method_22903();
            transform.method_22904(0.5, 1.2, 0.5);
            transform.method_22907(mc.method_1561().method_24197());
            transform.method_22905(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.method_23760().method_23761();
            int opacity = (int)(mc.field_1690.method_19343(0.25f) * 255.0f) << 24;
            float width = (float)(-font.method_1727(label)) / 2.0f;
            font.method_27521(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, class_327.class_6415.field_33994, opacity, lightmapCoord);
            font.method_27521(label, width, 0.0f, -1, false, matrix, buffers, class_327.class_6415.field_33993, 0, lightmapCoord);
            transform.method_22909();
        }
        transform.method_46416(0.5f, 0.5f, 0.5f);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        if (label != null && (label.equals("Dinnerbone") || label.equals("Grumm"))) {
            transform.method_22905(1.0f, -1.0f, 1.0f);
        }
        transform.method_46416(-0.5f, -0.5f, -0.5f);
        int colour = turtle.getColour();
        ComputerFamily family = turtle.getFamily();
        class_2960 overlay = turtle.getOverlay();
        class_2960 class_29602 = TurtleBlockEntityRenderer.getTurtleModel(family, colour != -1);
        if (colour == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = colour;
        }
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, class_29602, nArray);
        class_2960 overlayModel = TurtleBlockEntityRenderer.getTurtleOverlayModel(overlay, Holiday.getCurrent() == Holiday.CHRISTMAS);
        if (overlayModel != null) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, overlayModel, null);
        }
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.method_22909();
    }

    private void renderUpgrade(class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight, TurtleBlockEntity turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.method_22903();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.method_46416(0.0f, 0.5f, 0.5f);
        transform.method_22907(class_7833.field_40713.rotationDegrees(toolAngle));
        transform.method_46416(0.0f, -0.5f, -0.5f);
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade, turtle.getAccess(), side);
        TurtleBlockEntityRenderer.applyTransformation(transform, model.getMatrix());
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, model.getModel(), null);
        transform.method_22909();
    }

    private void renderModel(class_4587 transform, class_4597 buffers, int lightmapCoord, int overlayLight, class_2960 modelLocation, @Nullable int[] tints) {
        class_1092 modelManager = class_310.method_1551().method_1480().method_4012().method_3303();
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, ClientPlatformHelper.get().getModel(modelManager, modelLocation), tints);
    }

    private void renderModel(class_4587 transform, class_4597 renderer, int lightmapCoord, int overlayLight, class_1087 model, @Nullable int[] tints) {
        ClientPlatformHelper.get().renderBakedModel(transform, renderer, model, lightmapCoord, overlayLight, tints);
    }

    private static void applyTransformation(class_4587 stack, class_4590 transformation) {
        Vector3f trans = transformation.method_35865();
        stack.method_46416(trans.x(), trans.y(), trans.z());
        stack.method_22907(transformation.method_22937());
        Vector3f scale = transformation.method_35866();
        stack.method_22905(scale.x(), scale.y(), scale.z());
        stack.method_22907(transformation.method_35867());
    }
}

