/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import com.google.common.base.Joiner;
import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.core.filesystem.MountHelpers;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;

public class FileMount
implements Mount {
    private static final Set<OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ);
    protected final Path root;

    public FileMount(Path root) {
        this.root = root;
    }

    protected Path resolvePath(String path) {
        return this.root.resolve(path);
    }

    protected boolean created() {
        return Files.exists(this.root, new LinkOption[0]);
    }

    @Override
    public boolean exists(String path) {
        return path.isEmpty() || Files.exists(this.resolvePath(path), new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(String path) {
        return path.isEmpty() || Files.isDirectory(this.resolvePath(path), new LinkOption[0]);
    }

    @Override
    public void list(String path, List<String> contents) throws FileOperationException {
        if (path.isEmpty() && !this.created()) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.resolvePath(path));){
            stream.forEach(x -> contents.add(x.getFileName().toString()));
        }
        catch (IOException e) {
            throw this.remapException(path, e);
        }
    }

    @Override
    public long getSize(String path) throws FileOperationException {
        BasicFileAttributes attributes = this.getAttributes(path);
        return attributes.isDirectory() ? 0L : attributes.size();
    }

    @Override
    public BasicFileAttributes getAttributes(String path) throws FileOperationException {
        if (path.isEmpty() && !this.created()) {
            return new FileAttributes(true, 0L);
        }
        try {
            return Files.readAttributes(this.resolvePath(path), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw this.remapException(path, e);
        }
    }

    @Override
    public SeekableByteChannel openForRead(String path) throws FileOperationException {
        Path file = this.resolvePath(path);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new FileOperationException(path, Files.exists(file, new LinkOption[0]) ? "Not a file" : "No such file");
        }
        try {
            return Files.newByteChannel(file, READ_OPTIONS, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.remapException(path, e);
        }
    }

    protected FileOperationException remapException(String fallbackPath, IOException exn) {
        FileOperationException fileOperationException;
        if (exn instanceof FileSystemException) {
            FileSystemException fsExn = (FileSystemException)exn;
            fileOperationException = this.remapException(fallbackPath, fsExn);
        } else {
            fileOperationException = new FileOperationException(fallbackPath, exn.getMessage() == null ? "Access denied" : exn.getMessage());
        }
        return fileOperationException;
    }

    protected FileOperationException remapException(String fallbackPath, FileSystemException exn) {
        String reason = MountHelpers.getReason(exn);
        String failedFile = exn.getFile();
        if (failedFile == null) {
            return new FileOperationException(fallbackPath, reason);
        }
        Path failedPath = Path.of(failedFile, new String[0]);
        return failedPath.startsWith(this.root) ? new FileOperationException(Joiner.on((char)'/').join((Iterable)this.root.relativize(failedPath)), reason) : new FileOperationException(fallbackPath, reason);
    }
}

