/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.impl.ServiceException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Services {
    private Services() {
    }

    public static <T> T load(Class<T> klass) {
        List<ServiceLoader.Provider<T>> services = ServiceLoader.load(klass).stream().toList();
        switch (services.size()) {
            case 1: {
                break;
            }
            case 0: {
                throw new IllegalStateException("Cannot find service for " + klass.getName());
            }
            default: {
                String serviceTypes = services.stream().map(x -> x.type().getName()).collect(Collectors.joining(", "));
                throw new IllegalStateException("Multiple services for " + klass.getName() + ": " + serviceTypes);
            }
        }
        return services.get(0).get();
    }

    public static <T> LoadedService<T> tryLoad(Class<T> klass) {
        try {
            return new LoadedService<T>(Services.load(klass), null);
        }
        catch (Exception | LinkageError e) {
            return new LoadedService<Object>(null, e);
        }
    }

    public static <T> T raise(Class<T> klass, @Nullable Throwable e) {
        throw new ServiceException("Failed to instantiate " + klass.getName(), e);
    }

    public static class LoadedService<T> {
        @Nullable
        private final T instance;
        @Nullable
        private final Throwable error;

        LoadedService(@Nullable T instance, @Nullable Throwable error) {
            this.instance = instance;
            this.error = error;
        }

        @Nullable
        public T instance() {
            return this.instance;
        }

        @Nullable
        public Throwable error() {
            return this.error;
        }
    }
}

