/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.detail.FabricDetailRegistries;
import dan200.computercraft.api.node.wired.WiredElementLookup;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.FabricCommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.details.FluidDetails;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.platform.FabricConfigFile;
import dan200.computercraft.shared.platform.NetworkHandler;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2591;
import net.minecraft.class_2593;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5218;
import net.minecraft.class_55;

public class ComputerCraft {
    private static final class_5218 SERVERCONFIG = new class_5218("serverconfig");

    public static void init() {
        NetworkHandler.init();
        ModRegistry.register();
        ModRegistry.registerMainThread();
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.COMPUTER_NORMAL.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.COMPUTER_ADVANCED.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.TURTLE_NORMAL.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.TURTLE_ADVANCED.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.SPEAKER.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.PRINTER.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.DISK_DRIVE.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.MONITOR_NORMAL.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> b.peripheral(), (class_2591)ModRegistry.BlockEntities.MONITOR_ADVANCED.get());
        PeripheralLookup.get().registerForBlockEntity((b, d) -> Config.enableCommandBlock ? new CommandBlockPeripheral((class_2593)b) : null, class_2591.field_11904);
        PeripheralLookup.get().registerForBlockEntity(WirelessModemBlockEntity::getPeripheral, (class_2591)ModRegistry.BlockEntities.WIRELESS_MODEM_NORMAL.get());
        PeripheralLookup.get().registerForBlockEntity(WirelessModemBlockEntity::getPeripheral, (class_2591)ModRegistry.BlockEntities.WIRELESS_MODEM_ADVANCED.get());
        PeripheralLookup.get().registerForBlockEntity(WiredModemFullBlockEntity::getPeripheral, (class_2591)ModRegistry.BlockEntities.WIRED_MODEM_FULL.get());
        PeripheralLookup.get().registerForBlockEntity(CableBlockEntity::getPeripheral, (class_2591)ModRegistry.BlockEntities.CABLE.get());
        WiredElementLookup.get().registerForBlockEntity((b, d) -> b.getElement(), (class_2591)ModRegistry.BlockEntities.WIRED_MODEM_FULL.get());
        WiredElementLookup.get().registerForBlockEntity(CableBlockEntity::getWiredElement, (class_2591)ModRegistry.BlockEntities.CABLE.get());
        CommandRegistrationCallback.EVENT.register((dispatcher, context, environment) -> CommandComputerCraft.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ((FabricConfigFile)ConfigSpec.serverSpec).load(server.method_27050(SERVERCONFIG).resolve("computercraft-server.toml"));
            CommonHooks.onServerStarting(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            CommonHooks.onServerStopped();
            ((FabricConfigFile)ConfigSpec.serverSpec).unload();
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> PlatformHelper.get().sendToPlayer(new UpgradesLoadedMessage(), player));
        ServerTickEvents.START_SERVER_TICK.register(CommonHooks::onServerTickStart);
        ServerTickEvents.START_SERVER_TICK.register(s -> CommonHooks.onServerTickEnd());
        PlayerBlockBreakEvents.BEFORE.register(FabricCommonHooks::onBlockDestroy);
        UseBlockCallback.EVENT.register(FabricCommonHooks::useOnBlock);
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_55.class_56 pool = CommonHooks.getExtraLootPool(id);
            if (pool != null) {
                tableBuilder.method_336(pool);
            }
        });
        CommonHooks.onDatapackReload((name, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener((String)name, (class_3302)listener)));
        FabricDetailRegistries.FLUID_VARIANT.addProvider(FluidDetails::fill);
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        Peripherals.addGenericLookup((world, pos, state, blockEntity, side, invalidate) -> InventoryMethods.extractContainer(world, pos, state, blockEntity, side));
    }

    private record ReloadListener(String name, class_3302 listener) implements IdentifiableResourceReloadListener
    {
        public class_2960 getFabricId() {
            return new class_2960("computercraft", this.name);
        }

        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }
    }
}

