/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;

public final class ComputerArgumentType
implements ArgumentType<ComputerSupplier> {
    private static final ComputerArgumentType INSTANCE = new ComputerArgumentType();

    public static ComputerArgumentType oneComputer() {
        return INSTANCE;
    }

    public static ServerComputer getComputerArgument(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return ((ComputerSupplier)context.getArgument(name, ComputerSupplier.class)).unwrap((class_2168)context.getSource());
    }

    private ComputerArgumentType() {
    }

    public ComputerSupplier parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ComputersArgumentType.ComputersSupplier supplier = ComputersArgumentType.someComputers().parse(reader);
        String selector = reader.getString().substring(start, reader.getCursor());
        return s -> {
            Collection<ServerComputer> computers = supplier.unwrap(s);
            if (computers.size() == 1) {
                return computers.iterator().next();
            }
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (ServerComputer computer : computers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(computer.getInstanceID());
            }
            reader.setCursor(start);
            throw Exceptions.COMPUTER_ARG_MANY.createWithContext((ImmutableStringReader)reader, (Object)selector, (Object)builder.toString());
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ComputersArgumentType.someComputers().listSuggestions(context, builder);
    }

    public Collection<String> getExamples() {
        return ComputersArgumentType.someComputers().getExamples();
    }

    @FunctionalInterface
    public static interface ComputerSupplier {
        public ServerComputer unwrap(class_2168 var1) throws CommandSyntaxException;
    }
}

