/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.ServerTableFormatter;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TableBuilder {
    private final String id;
    private int columns = -1;
    @Nullable
    private final class_2561[] headers;
    private final ArrayList<class_2561[]> rows = new ArrayList();
    private int additional;

    public TableBuilder(String id, class_2561 ... headers) {
        this.id = id;
        this.headers = headers;
        this.columns = headers.length;
    }

    public TableBuilder(String id) {
        this.id = id;
        this.headers = null;
    }

    public TableBuilder(String id, String ... headers) {
        this.id = id;
        this.headers = new class_2561[headers.length];
        this.columns = headers.length;
        for (int i = 0; i < headers.length; ++i) {
            this.headers[i] = ChatHelpers.header(headers[i]);
        }
    }

    public void row(class_2561 ... row) {
        if (this.columns == -1) {
            this.columns = row.length;
        }
        if (row.length != this.columns) {
            throw new IllegalArgumentException("Row is the incorrect length");
        }
        this.rows.add(row);
    }

    public String getId() {
        return this.id;
    }

    public int getColumns() {
        return this.columns;
    }

    @Nullable
    public class_2561[] getHeaders() {
        return this.headers;
    }

    public List<class_2561[]> getRows() {
        return this.rows;
    }

    public int getAdditional() {
        return this.additional;
    }

    public void setAdditional(int additional) {
        this.additional = additional;
    }

    public void trim(int height) {
        if (this.rows.size() > height) {
            this.additional += this.rows.size() - height - 1;
            this.rows.subList(height - 1, this.rows.size()).clear();
        }
    }

    public void display(class_2168 source) {
        if (CommandUtils.isPlayer(source)) {
            this.trim(18);
            class_3222 player = (class_3222)Nullability.assertNonNull(source.method_9228());
            PlatformHelper.get().sendToPlayer(new ChatTableClientMessage(this), player);
        } else {
            this.trim(100);
            new ServerTableFormatter(source).display(this);
        }
    }
}

