/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.config;

import com.google.common.base.Splitter;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public interface ConfigFile {
    public static final String TRANSLATION_PREFIX = "gui.computercraft.config.";
    public static final Splitter SPLITTER = Splitter.on((char)'.');

    public Stream<Entry> entries();

    @Nullable
    public Entry getEntry(String var1);

    @FunctionalInterface
    public static interface ConfigListener {
        public void onConfigChanged(@Nullable Path var1);
    }

    public static abstract class Builder {
        protected final Deque<String> groupStack = new ArrayDeque<String>();

        protected String getTranslation(String name) {
            StringBuilder key = new StringBuilder(ConfigFile.TRANSLATION_PREFIX);
            for (String group : this.groupStack) {
                key.append(group).append('.');
            }
            key.append(name);
            return key.toString();
        }

        public abstract Builder comment(String var1);

        @OverridingMethodsMustInvokeSuper
        public void push(String name) {
            this.groupStack.addLast(name);
        }

        @OverridingMethodsMustInvokeSuper
        public void pop() {
            this.groupStack.removeLast();
        }

        public abstract Builder worldRestart();

        public abstract <T> Value<T> define(String var1, T var2);

        public abstract Value<Boolean> define(String var1, boolean var2);

        public abstract Value<Integer> defineInRange(String var1, int var2, int var3, int var4);

        public abstract <T> Value<List<? extends T>> defineList(String var1, List<? extends T> var2, Predicate<Object> var3);

        public abstract <V extends Enum<V>> Value<V> defineEnum(String var1, V var2);

        public abstract ConfigFile build(ConfigListener var1);
    }

    public static interface Group
    extends Entry {
    }

    public static interface Value<T>
    extends Entry,
    Supplier<T> {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Entry {
        public String translationKey();

        public String comment();
    }
}

