/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public final class RecipeModHelpers {
    static final List<Supplier<TurtleItem>> TURTLES = List.of(ModRegistry.Items.TURTLE_NORMAL, ModRegistry.Items.TURTLE_ADVANCED);
    static final List<Supplier<PocketComputerItem>> POCKET_COMPUTERS = List.of(ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);

    private RecipeModHelpers() {
    }

    public static boolean shouldRemoveRecipe(class_2960 id) {
        if (!id.method_12836().equals("computercraft")) {
            return false;
        }
        String path = id.method_12832();
        return path.startsWith("turtle_normal/") || path.startsWith("turtle_advanced/") || path.startsWith("pocket_normal/") || path.startsWith("pocket_advanced/");
    }

    public static List<class_1799> getExtraStacks() {
        ArrayList<class_1799> upgradeItems = new ArrayList<class_1799>();
        for (Supplier<TurtleItem> supplier : TURTLES) {
            TurtleItem turtle = supplier.get();
            for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
                upgradeItems.add(turtle.create(-1, null, -1, null, UpgradeData.ofDefault(iTurtleUpgrade), 0, null));
            }
        }
        for (Supplier<IColouredItem> supplier : POCKET_COMPUTERS) {
            PocketComputerItem pocket = (PocketComputerItem)supplier.get();
            for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
                upgradeItems.add(pocket.create(-1, null, -1, UpgradeData.ofDefault(iPocketUpgrade)));
            }
        }
        return upgradeItems;
    }
}

