/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.Expander;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.monitor.MonitorPeripheral;
import dan200.computercraft.shared.peripheral.monitor.MonitorState;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.XYPair;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorBlockEntity
extends class_2586 {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorBlockEntity.class);
    public static final double RENDER_BORDER = 0.125;
    public static final double RENDER_MARGIN = 0.03125;
    public static final double RENDER_PIXEL_SCALE = 0.015625;
    private static final String NBT_X = "XIndex";
    private static final String NBT_Y = "YIndex";
    private static final String NBT_WIDTH = "Width";
    private static final String NBT_HEIGHT = "Height";
    private final boolean advanced;
    @Nullable
    private ServerMonitor serverMonitor;
    @Nullable
    private ClientMonitor clientMonitor;
    @Nullable
    private MonitorPeripheral peripheral;
    private final Set<IComputerAccess> computers = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean needsUpdate = false;
    private boolean needsValidating = false;
    private boolean destroyed = false;
    boolean enqueued;
    @Nullable
    TerminalState cached;
    private int width = 1;
    private int height = 1;
    private int xIndex = 0;
    private int yIndex = 0;
    @Nullable
    private class_2338 bbPos;
    @Nullable
    private class_2680 bbState;
    private int bbX;
    private int bbY;
    private int bbWidth;
    private int bbHeight;
    @Nullable
    private class_238 boundingBox;
    TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public MonitorBlockEntity(class_2591<? extends MonitorBlockEntity> type, class_2338 pos, class_2680 state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
    }

    public void method_10996() {
        super.method_10996();
        this.needsValidating = true;
        TickScheduler.schedule(this.tickToken);
    }

    void destroy() {
        if (!this.method_10997().field_9236) {
            this.contractNeighbours();
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.clientMonitor != null && this.xIndex == 0 && this.yIndex == 0) {
            this.clientMonitor.destroy();
        }
    }

    public void method_11007(class_2487 tag) {
        tag.method_10569(NBT_X, this.xIndex);
        tag.method_10569(NBT_Y, this.yIndex);
        tag.method_10569(NBT_WIDTH, this.width);
        tag.method_10569(NBT_HEIGHT, this.height);
        super.method_11007(tag);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        int oldXIndex = this.xIndex;
        int oldYIndex = this.yIndex;
        this.xIndex = nbt.method_10550(NBT_X);
        this.yIndex = nbt.method_10550(NBT_Y);
        this.width = nbt.method_10550(NBT_WIDTH);
        this.height = nbt.method_10550(NBT_HEIGHT);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.onClientLoad(oldXIndex, oldYIndex);
        }
    }

    void blockTick() {
        if (this.needsValidating) {
            this.needsValidating = false;
            this.validate();
        }
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.expand();
        }
        if (this.xIndex != 0 || this.yIndex != 0 || this.serverMonitor == null) {
            return;
        }
        if (this.serverMonitor.pollResized()) {
            this.eachComputer(c -> c.queueEvent("monitor_resize", c.getAttachmentName()));
        }
        if (this.serverMonitor.pollTerminalChanged()) {
            MonitorWatcher.enqueue(this);
        }
    }

    @Nullable
    @VisibleForTesting
    public ServerMonitor getCachedServerMonitor() {
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor getServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        MonitorBlockEntity origin = this.getOrigin().getMonitor();
        if (origin == null) {
            return null;
        }
        this.serverMonitor = origin.serverMonitor;
        return this.serverMonitor;
    }

    @Nullable
    private ServerMonitor createServerMonitor() {
        if (this.serverMonitor != null) {
            return this.serverMonitor;
        }
        if (this.xIndex == 0 && this.yIndex == 0) {
            this.serverMonitor = new ServerMonitor(this.advanced, this);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                    if (monitor == null) continue;
                    monitor.serverMonitor = this.serverMonitor;
                }
            }
            return this.serverMonitor;
        }
        class_2586 te = this.field_11863.method_8321(this.toWorldPos(0, 0));
        if (!(te instanceof MonitorBlockEntity)) {
            return null;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        this.serverMonitor = monitor.createServerMonitor();
        return this.serverMonitor;
    }

    private void createServerTerminal() {
        ServerMonitor monitor = this.createServerMonitor();
        if (monitor != null && monitor.getTerminal() == null) {
            monitor.rebuild();
        }
    }

    @Nullable
    public ClientMonitor getClientMonitor() {
        if (this.clientMonitor != null) {
            return this.clientMonitor;
        }
        class_2586 te = this.field_11863.method_8321(this.toWorldPos(0, 0));
        if (!(te instanceof MonitorBlockEntity)) {
            return null;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)te;
        this.clientMonitor = monitor.clientMonitor;
        return this.clientMonitor;
    }

    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public final class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10569(NBT_X, this.xIndex);
        nbt.method_10569(NBT_Y, this.yIndex);
        nbt.method_10569(NBT_WIDTH, this.width);
        nbt.method_10569(NBT_HEIGHT, this.height);
        return nbt;
    }

    private void onClientLoad(int oldXIndex, int oldYIndex) {
        if (oldXIndex != this.xIndex || oldYIndex != this.yIndex) {
            if (oldXIndex == 0 && oldYIndex == 0 && this.clientMonitor != null) {
                this.clientMonitor.destroy();
            }
            this.clientMonitor = null;
        }
        if (this.xIndex == 0 && this.yIndex == 0 && this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
    }

    public final void read(TerminalState state) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            LOG.warn("Receiving monitor state for non-origin terminal at {}", (Object)this.method_11016());
            return;
        }
        if (this.clientMonitor == null) {
            this.clientMonitor = new ClientMonitor(this);
        }
        this.clientMonitor.read(state);
    }

    private void updateBlockState() {
        this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657(MonitorBlock.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(this.yIndex < this.height - 1, this.yIndex > 0, this.xIndex > 0, this.xIndex < this.width - 1))), 2);
    }

    public class_2350 getDirection() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)MonitorBlock.FACING) ? (class_2350)state.method_11654((class_2769)MonitorBlock.FACING) : class_2350.field_11043;
    }

    public class_2350 getOrientation() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)MonitorBlock.ORIENTATION) ? (class_2350)state.method_11654((class_2769)MonitorBlock.ORIENTATION) : class_2350.field_11043;
    }

    public class_2350 getFront() {
        class_2350 orientation = this.getOrientation();
        return orientation == class_2350.field_11043 ? this.getDirection() : orientation;
    }

    public class_2350 getRight() {
        return this.getDirection().method_10160();
    }

    public class_2350 getDown() {
        class_2350 orientation = this.getOrientation();
        if (orientation == class_2350.field_11043) {
            return class_2350.field_11036;
        }
        return orientation == class_2350.field_11033 ? this.getDirection() : this.getDirection().method_10153();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    boolean isCompatible(MonitorBlockEntity other) {
        return !other.destroyed && this.advanced == other.advanced && this.getOrientation() == other.getOrientation() && this.getDirection() == other.getDirection();
    }

    private MonitorState getLoadedMonitor(int x, int y) {
        if (x == this.xIndex && y == this.yIndex) {
            return MonitorState.present(this);
        }
        class_2338 pos = this.toWorldPos(x, y);
        class_1937 world = this.method_10997();
        if (world == null || !world.method_8477(pos)) {
            return MonitorState.UNLOADED;
        }
        class_2586 tile = world.method_8321(pos);
        if (!(tile instanceof MonitorBlockEntity)) {
            return MonitorState.MISSING;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
        return this.isCompatible(monitor) ? MonitorState.present(monitor) : MonitorState.MISSING;
    }

    private MonitorState getOrigin() {
        return this.getLoadedMonitor(0, 0);
    }

    class_2338 toWorldPos(int x, int y) {
        if (this.xIndex == x && this.yIndex == y) {
            return this.method_11016();
        }
        return this.method_11016().method_10079(this.getRight(), -this.xIndex + x).method_10079(this.getDown(), -this.yIndex + y);
    }

    void resize(int width, int height) {
        if (this.xIndex != 0 || this.yIndex != 0) {
            this.serverMonitor = null;
        }
        this.xIndex = 0;
        this.yIndex = 0;
        this.width = width;
        this.height = height;
        boolean needsTerminal = false;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null || monitor.peripheral == null) continue;
                needsTerminal = true;
                break block0;
            }
        }
        if (needsTerminal) {
            if (this.serverMonitor == null) {
                this.serverMonitor = new ServerMonitor(this.advanced, this);
            }
            this.serverMonitor.rebuild();
        } else if (this.serverMonitor != null) {
            this.serverMonitor.reset();
        }
        class_2338 pos = this.method_11016();
        class_2350 down = this.getDown();
        class_2350 right = this.getRight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                MonitorBlockEntity monitor;
                class_2586 other = this.method_10997().method_8321(pos.method_10079(right, x).method_10079(down, y));
                if (!(other instanceof MonitorBlockEntity) || !this.isCompatible(monitor = (MonitorBlockEntity)other)) continue;
                monitor.xIndex = x;
                monitor.yIndex = y;
                monitor.width = width;
                monitor.height = height;
                monitor.serverMonitor = this.serverMonitor;
                monitor.needsValidating = false;
                monitor.needsUpdate = false;
                monitor.updateBlockState();
                BlockEntityHelpers.updateBlock(monitor);
            }
        }
        this.assertInvariant();
    }

    void updateNeighborsDeferred() {
        this.needsUpdate = true;
    }

    void expand() {
        MonitorBlockEntity monitor = this.getOrigin().getMonitor();
        if (monitor != null && monitor.xIndex == 0 && monitor.yIndex == 0) {
            new Expander(monitor).expand();
        }
    }

    private void contractNeighbours() {
        if (this.width == 1 && this.height == 1) {
            return;
        }
        class_2338 pos = this.method_11016();
        class_2350 down = this.getDown();
        class_2350 right = this.getRight();
        class_2338 origin = this.toWorldPos(0, 0);
        MonitorBlockEntity toLeft = null;
        MonitorBlockEntity toAbove = null;
        MonitorBlockEntity toRight = null;
        MonitorBlockEntity toBelow = null;
        if (this.xIndex > 0) {
            toLeft = this.tryResizeAt(pos.method_10079(right, -this.xIndex), this.xIndex, 1);
        }
        if (this.yIndex > 0) {
            toAbove = this.tryResizeAt(origin, this.width, this.yIndex);
        }
        if (this.xIndex < this.width - 1) {
            toRight = this.tryResizeAt(pos.method_10079(right, 1), this.width - this.xIndex - 1, 1);
        }
        if (this.yIndex < this.height - 1) {
            toBelow = this.tryResizeAt(origin.method_10079(down, this.yIndex + 1), this.width, this.height - this.yIndex - 1);
        }
        if (toLeft != null) {
            toLeft.expand();
        }
        if (toAbove != null) {
            toAbove.expand();
        }
        if (toRight != null) {
            toRight.expand();
        }
        if (toBelow != null) {
            toBelow.expand();
        }
    }

    @Nullable
    private MonitorBlockEntity tryResizeAt(class_2338 pos, int width, int height) {
        MonitorBlockEntity monitor;
        class_2586 tile = this.field_11863.method_8321(pos);
        if (tile instanceof MonitorBlockEntity && this.isCompatible(monitor = (MonitorBlockEntity)tile)) {
            monitor.resize(width, height);
            return monitor;
        }
        return null;
    }

    private boolean checkMonitorAt(int xIndex, int yIndex) {
        MonitorState state = this.getLoadedMonitor(xIndex, yIndex);
        if (state.isMissing()) {
            return false;
        }
        MonitorBlockEntity monitor = state.getMonitor();
        if (monitor == null) {
            return true;
        }
        return monitor.xIndex == xIndex && monitor.yIndex == yIndex && monitor.width == this.width && monitor.height == this.height;
    }

    private void validate() {
        if (this.xIndex == 0 && this.yIndex == 0 && this.width == 1 && this.height == 1) {
            return;
        }
        if (this.xIndex >= 0 && this.xIndex <= this.width && this.width > 0 && this.width <= Config.monitorWidth && this.yIndex >= 0 && this.yIndex <= this.height && this.height > 0 && this.height <= Config.monitorHeight && this.checkMonitorAt(0, 0) && this.checkMonitorAt(0, this.height - 1) && this.checkMonitorAt(this.width - 1, 0) && this.checkMonitorAt(this.width - 1, this.height - 1)) {
            return;
        }
        LOG.warn("Monitor is malformed, resetting to 1x1.");
        this.resize(1, 1);
        this.needsUpdate = true;
    }

    void monitorTouched(float xPos, float yPos, float zPos) {
        if (!this.advanced) {
            return;
        }
        XYPair pair = XYPair.of(xPos, yPos, zPos, this.getDirection(), this.getOrientation()).add(this.xIndex, this.height - this.yIndex - 1);
        if ((double)pair.x() > (double)this.width - 0.125 || (double)pair.y() > (double)this.height - 0.125 || (double)pair.x() < 0.125 || (double)pair.y() < 0.125) {
            return;
        }
        ServerMonitor serverTerminal = this.getServerMonitor();
        if (serverTerminal == null) {
            return;
        }
        NetworkedTerminal originTerminal = serverTerminal.getTerminal();
        if (originTerminal == null) {
            return;
        }
        double xCharWidth = ((double)this.width - 0.3125) / (double)originTerminal.getWidth();
        double yCharHeight = ((double)this.height - 0.3125) / (double)originTerminal.getHeight();
        int xCharPos = (int)Math.min((double)originTerminal.getWidth(), Math.max(((double)pair.x() - 0.125 - 0.03125) / xCharWidth + 1.0, 1.0));
        int yCharPos = (int)Math.min((double)originTerminal.getHeight(), Math.max(((double)pair.y() - 0.125 - 0.03125) / yCharHeight + 1.0, 1.0));
        this.eachComputer(c -> c.queueEvent("monitor_touch", c.getAttachmentName(), xCharPos, yCharPos));
    }

    private void eachComputer(Consumer<IComputerAccess> fun) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                for (IComputerAccess computer : monitor.computers) {
                    fun.accept(computer);
                }
            }
        }
    }

    public IPeripheral peripheral() {
        this.createServerTerminal();
        MonitorPeripheral peripheral = this.peripheral != null ? this.peripheral : (this.peripheral = new MonitorPeripheral(this));
        this.assertInvariant();
        return peripheral;
    }

    void addComputer(IComputerAccess computer) {
        this.computers.add(computer);
    }

    void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public class_238 getRenderBoundingBox() {
        if (this.boundingBox != null && this.method_11010().equals(this.bbState) && this.method_11016().equals((Object)this.bbPos) && this.xIndex == this.bbX && this.yIndex == this.bbY && this.width == this.bbWidth && this.height == this.bbHeight) {
            return this.boundingBox;
        }
        this.bbState = this.method_11010();
        this.bbPos = this.method_11016();
        this.bbX = this.xIndex;
        this.bbY = this.yIndex;
        this.bbWidth = this.width;
        this.bbHeight = this.height;
        class_2338 startPos = this.toWorldPos(0, 0);
        class_2338 endPos = this.toWorldPos(this.width, this.height);
        this.boundingBox = new class_238((double)Math.min(startPos.method_10263(), endPos.method_10263()), (double)Math.min(startPos.method_10264(), endPos.method_10264()), (double)Math.min(startPos.method_10260(), endPos.method_10260()), (double)(Math.max(startPos.method_10263(), endPos.method_10263()) + 1), (double)(Math.max(startPos.method_10264(), endPos.method_10264()) + 1), (double)(Math.max(startPos.method_10260(), endPos.method_10260()) + 1));
        return this.boundingBox;
    }

    private void assertInvariant() {
        assert (this.checkInvariants()) : "Monitor invariants failed. See logs.";
    }

    private boolean checkInvariants() {
        LOG.debug("Checking monitor invariants at {}", (Object)this.method_11016());
        boolean okay = true;
        if (this.width <= 0 || this.height <= 0) {
            okay = false;
            LOG.error("Monitor {} has non-positive of {}x{}", new Object[]{this.method_11016(), this.width, this.height});
        }
        boolean hasPeripheral = false;
        MonitorBlockEntity origin = this.getOrigin().getMonitor();
        ServerMonitor serverMonitor = origin != null ? origin.serverMonitor : this.serverMonitor;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                MonitorBlockEntity monitor = this.getLoadedMonitor(x, y).getMonitor();
                if (monitor == null) continue;
                hasPeripheral |= monitor.peripheral != null;
                if (monitor.serverMonitor != null && monitor.serverMonitor != serverMonitor) {
                    okay = false;
                    LOG.error("Monitor {} expected to be have serverMonitor={}, but was {}", new Object[]{monitor.method_11016(), serverMonitor, monitor.serverMonitor});
                }
                if (monitor.xIndex != x || monitor.yIndex != y) {
                    okay = false;
                    LOG.error("Monitor {} expected to be at {},{}, but believes it is {},{}", new Object[]{monitor.method_11016(), x, y, monitor.xIndex, monitor.yIndex});
                }
                if (monitor.width != this.width || monitor.height != this.height) {
                    okay = false;
                    LOG.error("Monitor {} expected to be size {},{}, but believes it is {},{}", new Object[]{monitor.method_11016(), this.width, this.height, monitor.width, monitor.height});
                }
                class_2680 expectedState = (class_2680)this.method_11010().method_11657(MonitorBlock.STATE, (Comparable)((Object)MonitorEdgeState.fromConnections(y < this.height - 1, y > 0, x > 0, x < this.width - 1)));
                if (monitor.method_11010() == expectedState) continue;
                okay = false;
                LOG.error("Monitor {} expected to have state {}, but has state {}", new Object[]{monitor.method_11010(), expectedState, monitor.method_11010()});
            }
        }
        if (hasPeripheral != (serverMonitor != null && serverMonitor.getTerminal() != null)) {
            okay = false;
            LOG.error("Peripheral is {}, but serverMonitor={} and serverMonitor.terminal={}", new Object[]{hasPeripheral, serverMonitor, serverMonitor == null ? null : serverMonitor.getTerminal()});
        }
        return okay;
    }
}

