/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class MonitorWatcher {
    private static final Queue<MonitorBlockEntity> watching = new ArrayDeque<MonitorBlockEntity>();

    private MonitorWatcher() {
    }

    static void enqueue(MonitorBlockEntity monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    public static void onWatch(class_2818 chunk, class_3222 player) {
        for (class_2586 te : chunk.method_12214().values()) {
            MonitorBlockEntity monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof MonitorBlockEntity) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (MonitorBlockEntity)te)) == null || monitor.enqueued) continue;
            TerminalState state = MonitorWatcher.getState(monitor, serverMonitor);
            PlatformHelper.get().sendToPlayer(new MonitorClientMessage(monitor.method_11016(), state), player);
        }
    }

    public static void onTick() {
        MonitorBlockEntity tile;
        boolean obeyLimit;
        long limit = Config.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            class_2818 chunk;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            class_2338 pos = tile.method_11016();
            class_1937 world = tile.method_10997();
            if (!(world instanceof class_3218) || ((class_3218)world).method_14178().field_17254.method_17210((chunk = world.method_8500(pos)).method_12004(), false).isEmpty()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            PlatformHelper.get().sendToAllTracking(new MonitorClientMessage(pos, state), chunk);
            limit -= (long)state.size();
        }
    }

    @Nullable
    private static ServerMonitor getMonitor(MonitorBlockEntity monitor) {
        return !monitor.method_11015() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static TerminalState getState(MonitorBlockEntity tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = new TerminalState(monitor.getTerminal());
        }
        return state;
    }
}

