/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.peripheral.speaker.DfpwmState;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.PauseAwareTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_151;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2766;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public abstract class SpeakerPeripheral
implements IPeripheral {
    public static final int SAMPLE_RATE = 48000;
    private final UUID source = UUID.randomUUID();
    @GuardedBy(value="computers")
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>();
    private long clock = 0L;
    private long lastPositionTime;
    @Nullable
    private SpeakerPosition lastPosition;
    private long lastPlayTime;
    private final List<PendingSound<class_6880<class_3414>>> pendingNotes = new ArrayList<PendingSound<class_6880<class_3414>>>();
    private final Object lock = new Object();
    private boolean shouldStop;
    @Nullable
    private PendingSound<class_2960> pendingSound = null;
    @Nullable
    private DfpwmState dfpwmState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean shouldStop;
        DfpwmState dfpwmState;
        PendingSound<class_2960> sound;
        ++this.clock;
        SpeakerPosition position = this.getPosition();
        class_1937 level = position.level();
        class_243 pos = position.position();
        if (level == null) {
            return;
        }
        MinecraftServer server = Nullability.assertNonNull(level.method_8503());
        List<PendingSound<class_6880<class_3414>>> list = this.pendingNotes;
        synchronized (list) {
            for (PendingSound<class_6880<class_3414>> sound2 : this.pendingNotes) {
                this.lastPlayTime = this.clock;
                server.method_3760().method_14605(null, pos.field_1352, pos.field_1351, pos.field_1350, (double)(sound2.volume * 16.0f), level.method_27983(), (class_2596)new class_2767((class_6880)sound2.sound, class_3419.field_15247, pos.field_1352, pos.field_1351, pos.field_1350, sound2.volume, sound2.pitch, level.method_8409().method_43055()));
            }
            this.pendingNotes.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            sound = this.pendingSound;
            dfpwmState = this.dfpwmState;
            this.pendingSound = null;
            shouldStop = this.shouldStop;
            if (shouldStop) {
                this.dfpwmState = null;
                dfpwmState = null;
                sound = null;
                this.shouldStop = false;
            }
        }
        if (shouldStop && this.lastPosition != null) {
            this.lastPosition = null;
            PlatformHelper.get().sendToAllPlayers(new SpeakerStopClientMessage(this.getSource()), server);
            return;
        }
        long now = PauseAwareTimer.getTime();
        if (sound != null) {
            this.lastPlayTime = this.clock;
            PlatformHelper.get().sendToAllAround(new SpeakerPlayClientMessage(this.getSource(), position, (class_2960)sound.sound, sound.volume, sound.pitch), (class_3218)level, pos, sound.volume * 16.0f);
            this.syncedPosition(position);
        } else if (dfpwmState != null && dfpwmState.shouldSendPending(now)) {
            PlatformHelper.get().sendToAllTracking(new SpeakerAudioClientMessage(this.getSource(), position, dfpwmState.getVolume(), dfpwmState.pullPending(now)), level.method_8500(class_2338.method_49638((class_2374)pos)));
            this.syncedPosition(position);
            Set<IComputerAccess> set = this.computers;
            synchronized (set) {
                for (IComputerAccess computer : this.computers) {
                    computer.queueEvent("speaker_audio_empty", computer.getAttachmentName());
                }
            }
        }
        if (this.lastPosition != null && this.clock - this.lastPositionTime >= 20L && !this.lastPosition.withinDistance(position, 0.1)) {
            PlatformHelper.get().sendToAllTracking(new SpeakerMoveClientMessage(this.getSource(), position), level.method_8500(class_2338.method_49638((class_2374)pos)));
            this.syncedPosition(position);
        }
    }

    public abstract SpeakerPosition getPosition();

    public UUID getSource() {
        return this.source;
    }

    public boolean madeSound() {
        DfpwmState state = this.dfpwmState;
        return this.clock - this.lastPlayTime <= 20L || state != null && state.isPlaying();
    }

    @Override
    public String getType() {
        return "speaker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playNote(ILuaContext context, String instrumentA, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)SpeakerPeripheral.clampVolume(LuaValues.checkFinite(1, volumeA.orElse(1.0)));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        class_2766 instrument = null;
        for (class_2766 testInstrument : class_2766.values()) {
            if (!testInstrument.method_15434().equalsIgnoreCase(instrumentA)) continue;
            instrument = testInstrument;
            break;
        }
        if (instrument == null) {
            throw new LuaException("Invalid instrument, \"" + instrument + "\"!");
        }
        List<PendingSound<class_6880<class_3414>>> list = this.pendingNotes;
        synchronized (list) {
            if (this.pendingNotes.size() >= Config.maxNotesPerTick) {
                return false;
            }
            this.pendingNotes.add(new PendingSound<class_6880>(instrument.method_11886(), volume, (float)Math.pow(2.0, ((double)pitch - 12.0) / 12.0)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final boolean playSound(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        class_2960 identifier;
        float volume = (float)SpeakerPeripheral.clampVolume(LuaValues.checkFinite(1, volumeA.orElse(1.0)));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        try {
            identifier = new class_2960(name);
        }
        catch (class_151 e) {
            throw new LuaException("Malformed sound name '" + name + "' ");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dfpwmState != null && this.dfpwmState.isPlaying()) {
                return false;
            }
            this.dfpwmState = null;
            this.pendingSound = new PendingSound<class_2960>(identifier, volume, pitch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(unsafe=true)
    public final boolean playAudio(ILuaContext context, LuaTable<?, ?> audio, Optional<Double> volume) throws LuaException {
        DfpwmState state;
        LuaValues.checkFinite(1, volume.orElse(0.0));
        int length = audio.length();
        if (length <= 0) {
            throw new LuaException("Cannot play empty audio");
        }
        if (length > 131072) {
            throw new LuaException("Audio data is too large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dfpwmState == null || !this.dfpwmState.isPlaying()) {
                this.dfpwmState = new DfpwmState();
            }
            state = this.dfpwmState;
            this.pendingSound = null;
        }
        return state.pushBuffer(audio, length, volume);
    }

    @LuaFunction
    public final void stop() {
        this.shouldStop = true;
    }

    private void syncedPosition(SpeakerPosition position) {
        this.lastPosition = position;
        this.lastPositionTime = this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(IComputerAccess computer) {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.add(computer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(IComputerAccess computer) {
        Set<IComputerAccess> set = this.computers;
        synchronized (set) {
            this.computers.remove(computer);
        }
    }

    static double clampVolume(double volume) {
        return class_3532.method_15350((double)volume, (double)0.0, (double)3.0);
    }

    private record PendingSound<T>(T sound, float volume, float pitch) {
    }
}

