/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkHandler.class);
    public static final class_2960 ID = new class_2960("computercraft", "main");
    private static final Int2ObjectMap<Function<class_2540, ? extends NetworkMessage<ClientNetworkContext>>> clientPackets = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<Function<class_2540, ? extends NetworkMessage<ServerNetworkContext>>> serverPackets = new Int2ObjectOpenHashMap();
    private static final Object2IntMap<Class<? extends NetworkMessage<?>>> packetIds = new Object2IntOpenHashMap();

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, handler, buf, responseSender) -> {
            NetworkMessage<ServerNetworkContext> packet = NetworkHandler.decodeServer(buf);
            if (packet != null) {
                server.execute(() -> packet.handle(() -> ((class_3244)handler).method_32311()));
            }
        });
        NetworkMessages.register(new NetworkMessages.PacketRegistry(){

            @Override
            public <T extends NetworkMessage<ClientNetworkContext>> void registerClientbound(int id, Class<T> type, Function<class_2540, T> decoder) {
                clientPackets.put(id, decoder);
                packetIds.put(type, id);
            }

            @Override
            public <T extends NetworkMessage<ServerNetworkContext>> void registerServerbound(int id, Class<T> type, Function<class_2540, T> decoder) {
                serverPackets.put(id, decoder);
                packetIds.put(type, id);
            }
        });
    }

    private static class_2540 encode(NetworkMessage<?> message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(packetIds.getInt(message.getClass()));
        message.toBytes(buf);
        return buf;
    }

    public static class_2658 encodeClient(NetworkMessage<ClientNetworkContext> message) {
        return new class_2658(ID, NetworkHandler.encode(message));
    }

    public static class_2817 encodeServer(NetworkMessage<ServerNetworkContext> message) {
        return new class_2817(ID, NetworkHandler.encode(message));
    }

    @Nullable
    private static <T> NetworkMessage<T> decode(Int2ObjectMap<Function<class_2540, ? extends NetworkMessage<T>>> packets, class_2540 buffer) {
        byte type = buffer.readByte();
        Function reader = (Function)packets.get((int)type);
        if (reader == null) {
            LOGGER.debug("Unknown packet {}", (Object)type);
            return null;
        }
        return (NetworkMessage)reader.apply(buffer);
    }

    @Nullable
    public static NetworkMessage<ServerNetworkContext> decodeServer(class_2540 buffer) {
        return NetworkHandler.decode(serverPackets, buffer);
    }

    @Nullable
    public static NetworkMessage<ClientNetworkContext> decodeClient(class_2540 buffer) {
        return NetworkHandler.decode(clientPackets, buffer);
    }
}

