/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.chain.IncompleteChainLink;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.util.NetworkingPackets;
import com.github.legoatoom.connectiblechains.util.PacketBufUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ChainPacketHandler {
    private final ObjectList<IncompleteChainLink> incompleteLinks = new ObjectArrayList(256);

    public ChainPacketHandler() {
        this.register();
    }

    private void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_CHAIN_ATTACH_PACKET_ID, (client, handler, packetByteBuf, responseSender) -> {
            int fromId = packetByteBuf.method_10816();
            int toId = packetByteBuf.method_10816();
            int typeId = packetByteBuf.method_10816();
            client.execute(() -> this.createLinks(client, fromId, new int[]{toId}, new int[]{typeId}));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_CHAIN_DETACH_PACKET_ID, (client, handler, packetByteBuf, responseSender) -> {
            int fromId = packetByteBuf.method_10816();
            int toId = packetByteBuf.method_10816();
            client.execute(() -> {
                if (client.field_1687 == null) {
                    return;
                }
                class_1297 from = client.field_1687.method_8469(fromId);
                class_1297 to = client.field_1687.method_8469(toId);
                if (from instanceof ChainKnotEntity) {
                    ChainKnotEntity knot = (ChainKnotEntity)from;
                    if (to == null) {
                        for (IncompleteChainLink link : this.incompleteLinks) {
                            if (link.primary != from || link.secondaryId != toId) continue;
                            link.destroy();
                        }
                    } else {
                        for (ChainLink link : knot.getLinks()) {
                            if (link.secondary != to) continue;
                            link.destroy(true);
                        }
                    }
                } else {
                    this.logBadActionTarget("detach from", from, fromId, "chain knot");
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_MULTI_CHAIN_ATTACH_PACKET_ID, (client, handler, packetByteBuf, responseSender) -> {
            int fromId = packetByteBuf.readInt();
            int[] toIds = packetByteBuf.method_10787();
            int[] types = packetByteBuf.method_10787();
            client.execute(() -> this.createLinks(client, fromId, toIds, types));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_SPAWN_CHAIN_COLLISION_PACKET, (client, handler, buf, responseSender) -> {
            int entityTypeID = buf.method_10816();
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(entityTypeID);
            UUID uuid = buf.method_10790();
            int entityId = buf.method_10816();
            class_243 pos = PacketBufUtil.readVec3d(buf);
            int typeId = buf.method_10816();
            client.execute(() -> {
                class_1297 e = this.createEntity(client, entityType, uuid, entityId, pos);
                if (e == null) {
                    return;
                }
                if (e instanceof ChainCollisionEntity) {
                    ChainCollisionEntity collider = (ChainCollisionEntity)e;
                    collider.setSourceItem((class_1792)class_7923.field_41178.method_10200(typeId));
                }
                assert (client.field_1687 != null);
                client.field_1687.method_2942(entityId, e);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_SPAWN_CHAIN_KNOT_PACKET, (client, handler, buf, responseSender) -> {
            int entityTypeId = buf.method_10816();
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(entityTypeId);
            UUID uuid = buf.method_10790();
            int entityId = buf.method_10816();
            class_243 pos = PacketBufUtil.readVec3d(buf);
            int typeId = buf.method_10816();
            client.execute(() -> {
                class_1297 e = this.createEntity(client, entityType, uuid, entityId, pos);
                if (e == null) {
                    return;
                }
                if (e instanceof ChainKnotEntity) {
                    ChainKnotEntity knot = (ChainKnotEntity)e;
                    knot.setChainItemSource((class_1792)class_7923.field_41178.method_10200(typeId));
                    knot.setGraceTicks((byte)0);
                }
                assert (client.field_1687 != null);
                client.field_1687.method_2942(entityId, e);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkingPackets.S2C_KNOT_CHANGE_TYPE_PACKET, (client, handler, buf, responseSender) -> {
            int knotId = buf.method_10816();
            int typeId = buf.method_10816();
            client.execute(() -> {
                if (client.field_1687 == null) {
                    return;
                }
                class_1297 entity = client.field_1687.method_8469(knotId);
                class_1792 chainType = (class_1792)class_7923.field_41178.method_10200(typeId);
                if (entity instanceof ChainKnotEntity) {
                    ChainKnotEntity knot = (ChainKnotEntity)entity;
                    knot.updateChainType(chainType);
                } else {
                    this.logBadActionTarget("change type of", entity, knotId, "chain knot");
                }
            });
        });
    }

    private void createLinks(class_310 client, int fromId, int[] toIds, int[] types) {
        if (client.field_1687 == null) {
            return;
        }
        class_1297 from = client.field_1687.method_8469(fromId);
        if (from instanceof ChainKnotEntity) {
            ChainKnotEntity knot = (ChainKnotEntity)from;
            for (int i = 0; i < toIds.length; ++i) {
                class_1297 to = client.field_1687.method_8469(toIds[i]);
                class_1792 chainType = (class_1792)class_7923.field_41178.method_10200(types[i]);
                if (to == null) {
                    this.incompleteLinks.add((Object)new IncompleteChainLink(knot, toIds[i], chainType));
                    continue;
                }
                ChainLink.create(knot, to, chainType);
            }
        } else {
            this.logBadActionTarget("attach from", from, fromId, "chain knot");
        }
    }

    private void logBadActionTarget(String action, class_1297 target, int targetId, String expectedTarget) {
        ConnectibleChains.LOGGER.warn(String.format("Tried to %s %s (#%d) which is not %s", action, target, targetId, expectedTarget));
    }

    @Nullable
    private class_1297 createEntity(class_310 client, class_1299<?> type, UUID uuid, int id, class_243 pos) {
        if (client.field_1687 == null) {
            ConnectibleChains.LOGGER.error("Tried to spawn entity in a null world!");
            return null;
        }
        class_1297 e = type.method_5883((class_1937)client.field_1687);
        if (e == null) {
            ConnectibleChains.LOGGER.error("Failed to create instance of entity with type {}.", type);
            return null;
        }
        e.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        e.method_5838(id);
        e.method_5826(uuid);
        e.method_18799(class_243.field_1353);
        return e;
    }

    public void tick() {
        this.incompleteLinks.removeIf(IncompleteChainLink::tryCompleteOrRemove);
    }
}

